#pragma once

#include <SFML/System/Vector2.hpp>

#include "engine/INIFile.h"
#include <SFML/Network.hpp>

class Config
{
public:
    struct Graphics
    {
	    static int width;
	    static int height;
    };
    
    struct PlatformerPlayer
    {
        static float maxEnergy;
        static float consumedEnergyOnJump;
        static float consumedEnergyPerSecondOnMove;
        static float consumedEnergyPerSecondOnHit;
        static float gainedEnergyPerSecondOnRecovery;
        static float recoveredEnergyOnRecovery;

        static sf::Vector2f gravity;

        static float horizontalAirFriction;
        static float horizontalGroundFriction;

        static float twoLegsJumpImpulse;
        static float oneLegJumpImpulse;
        static float noLegJumpImpulse;
        
        static float twoLegsHorizontalAcceleration;
        static float oneLegHorizontalAcceleration;
        static float noLegHorizontalAcceleration;

        static float twoLegsMaxHorizontalVelocity;
        static float oneLegMaxHorizontalVelocity;
        static float noLegMaxHorizontalVelocity;
        
        static float twoArmsHitDamage;
        static float oneArmHitDamage;
        static float twoArmsHitDuration;
        static float oneArmHitDuration;

        static float hitCoolDown;
    };

    struct PlatformerEnemy
    {
        static float speed;
        static float life;
        static int maxHeight;
        static int commestibles;
    };

    struct Str
    {
        static float energyPerCholesterol;
        static float goodEnergyPerCholesterol;
        static float grasPerCholesterol;
        static float energyPerNegativeCholesterol;
        static float goodEnergyPerNegativeCholesterol;
        static float grasPerNegativeCholesterol;
        static float multiplierGatherAmount;
        static float multiplierGrasSpeed;
    };

    struct Network
    {
        static unsigned short udpReadPort;
        static unsigned short udpWritePort;
        static unsigned short tcpPort;
        static unsigned int lookupLiveTime;
        static sf::IpAddress serverAddress;
        static std::string logMessage;
    };

	static void LoadFromFile(const char* pFile);
};