#pragma once

#include <SFML/Graphics.hpp>
#include <map>

class BoundingBox
{
private:
    sf::Rect<float> mRect;
    void (*mCallback)(void* pThis, BoundingBox const& pCollider, unsigned int pLayer);
    void* mCallbackThis;
    std::map<unsigned int, std::pair<void(*)(void*, BoundingBox const&, unsigned int), void*>> mCallbackLayers;
    template <class T, void (T::*Fun)(void)> static void shortCallback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer);
    template <class T, void (T::*Fun)(BoundingBox const&)> static void callback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer);
    template <class T, void (T::*Fun)(BoundingBox const&, unsigned int)> static void fullCallback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer);
    void callCallback(BoundingBox const& pCollider, unsigned int pLayer) const;
public:
    BoundingBox(void);
    BoundingBox(float pWidth, float pHeight, float pLeft = 0, float pTop = 0);
    BoundingBox(sf::Vector2f const& pSize);
    BoundingBox(sf::Vector2f const& pSize, sf::Vector2f const& pPos);
    ~BoundingBox(void);
    sf::Vector2f getBoxPosition() const;
    sf::Vector2f getBoxSize() const;
    sf::Rect<float> const& getBoxRect() const;
    void setBoxPosition(float pLeft, float pTop);
    void setBoxPosition(sf::Vector2f const& pPos);
    void setBoxSize(float pWidth, float pHeight);
    void setBoxSize(sf::Vector2f const& pSize);
    bool testCollision(BoundingBox const& pAABB) const;
    bool testCollision(sf::Vector2f const& pPosition) const;
    void checkCollisions(std::vector<BoundingBox const*> const& pBoundingBoxes, unsigned int pLayer) const;
    void drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const;
    template <class T, void (T::*Fun)(void)> void setShortCallback(T& pThis);
    template <class T, void (T::*Fun)(BoundingBox const&)> void setCallback(T& pThis);
    template <class T, void (T::*Fun)(BoundingBox const&, unsigned int)> void setFullCallback(T& pThis);
    template <class T, void (T::*Fun)(void)> void setShortCallback(unsigned int pLayer, T& pThis);
    template <class T, void (T::*Fun)(BoundingBox const&)> void setCallback(unsigned int pLayer, T& pThis);
    template <class T, void (T::*Fun)(BoundingBox const&, unsigned int)> void setFullCallback(unsigned int pLayer, T& pThis);
};

#include "BoundingBox.hpp"
