#pragma once

#include "BoundingBox.h"

template <class T, void (T::*Fun)(void)> void BoundingBox::setShortCallback(T& pThis)
{
    mCallbackThis = &pThis;
    mCallback = (void(*)(void*, BoundingBox const&, unsigned int))shortCallback<T, Fun>;
}

template <class T, void (T::*Fun)(BoundingBox const&)> void BoundingBox::setCallback(T& pThis)
{
    mCallbackThis = &pThis;
    mCallback = (void(*)(void*, BoundingBox const&, unsigned int))callback<T, Fun>;
}

template <class T, void (T::*Fun)(BoundingBox const&, unsigned int)> void BoundingBox::setFullCallback(T& pThis)
{
    mCallbackThis = &pThis;
    mCallback = (void(*)(void*, BoundingBox const&, unsigned int))fullCallback<T, Fun>;
}

template <class T, void (T::*Fun)(void)> void BoundingBox::setShortCallback(unsigned int pLayer, T& pThis)
{
    mCallbackLayers[pLayer] = std::pair<void (*)(void*, BoundingBox const&, unsigned int), T*>(reinterpret_cast<void (*)(void*, BoundingBox const&, unsigned int)>(shortCallback<T, Fun>), &pThis);
}

template <class T, void (T::*Fun)(BoundingBox const&)> void BoundingBox::setCallback(unsigned int pLayer, T& pThis)
{
    mCallbackLayers[pLayer] = std::pair<void (*)(void*, BoundingBox const&, unsigned int), T*>(reinterpret_cast<void (*)(void*, BoundingBox const&, unsigned int)>(callback<T, Fun>), &pThis);
}

template <class T, void (T::*Fun)(BoundingBox const&, unsigned int)> void BoundingBox::setFullCallback(unsigned int pLayer, T& pThis)
{
    mCallbackLayers[pLayer] = std::pair<void (*)(void*, BoundingBox const&, unsigned int), T*>(reinterpret_cast<void (*)(void*, BoundingBox const&, unsigned int)>(fullCallback<T, Fun>), &pThis);
}

template <class T, void (T::*Fun)(void)> static void BoundingBox::shortCallback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer)
{
    (pThis->*Fun)();
}

template <class T, void (T::*Fun)(BoundingBox const&)> static void BoundingBox::callback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer)
{
    (pThis->*Fun)(pCollider);
}

template <class T, void (T::*Fun)(BoundingBox const&, unsigned int pLayer)> static void BoundingBox::fullCallback(T* pThis, BoundingBox const& pCollider, unsigned int pLayer)
{
    (pThis->*Fun)(pCollider, pLayer);
}
