#pragma once
#include <SFML/Graphics.hpp>
#include "engine/Callback.h"

class Button
{
private:
	sf::Text mText;
	sf::Vector2f mPosition;
	sf::Vector2f mSize;
	sf::Color mColor;
	sf::Color mColorHover;
	bool mHasColorHover;
	sf::Color mColorActive;
	bool mHasColorActive;
	sf::Uint32 mStyle;
	sf::Uint32 mStyleHover;
	bool mHasStyleHover;
	sf::Uint32 mStyleActive;
	bool mHasStyleActive;
	unsigned int mCharacterSize;
	unsigned int mCharacterSizeHover;
	bool mHasCharacterSizeHover;
	unsigned int mCharacterSizeActive;
	bool mHasCharacterSizeActive;
	bool mIsHover;
	bool mWasPressed;
	bool mIsPressed;
	Callback<> mCallback;
	void updatePosition();
public:
	Button(std::string const& pString = "", sf::Font const& pFont = sf::Font::getDefaultFont(), bool pIsButton = true, unsigned int pCharacterSize = 30U);
	void update();
	void draw(sf::RenderTarget* pTarget);
	bool isClicked();
	std::string getString() { return mText.getString(); }
	void setString(std::string const& pString) { mText.setString(pString); updatePosition(); }
	sf::Vector2f getPosition() { return mPosition; }
	void setPosition(sf::Vector2f const& pPosition) { mPosition = pPosition; updatePosition(); }
	sf::Vector2f getSize() { return mSize; }
	void setSize(sf::Vector2f const& pSize) { mSize = pSize; updatePosition(); }
	sf::Color getColor() { return mColor; }
	void setColor(sf::Color const& pColor) { mColor = pColor; }
	sf::Color getColorHover() { return mHasColorHover ? mColorHover : mColor; }
	void setColorHover(sf::Color const& pColor) { mColorHover = pColor; mHasColorHover = true; }
	sf::Color getColorActive() { return mHasColorActive ? mColorActive : mColor; }
	void setColorActive(sf::Color const& pColor) { mColorActive = pColor; mHasColorActive = true; }
	sf::Uint32 getStyle() { return mStyle; }
	void setStyle(sf::Uint32 pStyle) { mStyle = pStyle; updatePosition(); }
	sf::Uint32 getStyleHover() { return mHasStyleHover ? mStyleHover : mStyle; }
	void setStyleHover(sf::Uint32 pStyle) { mStyleHover = pStyle; mHasStyleHover = true; updatePosition(); }
	sf::Uint32 getStyleActive() { return mHasStyleActive ? mStyleActive : mStyle; }
	void setStyleActive(sf::Uint32 pStyle) { mStyleActive = pStyle; mHasStyleActive = true; updatePosition(); }
	sf::Font const& getFont() { return mText.getFont(); }
	void setFont(sf::Font const& pFont) { mText.setFont(pFont); updatePosition(); }
	unsigned int getCharacterSize() { return mCharacterSize; }
	void setCharacterSize(unsigned int pTextSize) { mCharacterSize = pTextSize; updatePosition(); }
	unsigned int getCharacterSizeHover() { return mHasCharacterSizeHover ? mCharacterSizeHover : mCharacterSize; }
	void setCharacterSizeHover(unsigned int pTextSize) { mCharacterSizeHover = pTextSize; mHasCharacterSizeHover = true; updatePosition(); }
	unsigned int getCharacterSizeActive() { return mHasCharacterSizeActive ? mCharacterSizeActive : mCharacterSize; }
	void setCharacterSizeActive(unsigned int pTextSize) { mCharacterSizeActive = pTextSize; mHasCharacterSizeActive = true; updatePosition(); }
	void setCallback(Callback<> const& pCallback) { mCallback = pCallback; }
	void clearCallback() { mCallback = Callback<>(); }
};