#pragma once

#define MAX_CALLBACK_ARGS 1

#define CAT(a, ...) _BASE_CAT(a, __VA_ARGS__)
#define _BASE_CAT(a, ...) a ## __VA_ARGS__
#define ARG_TYPE(N) ARG_TYPE_NC(N)
#define ARG_TYPE_NC(N) CAT(Arg, N)
#define ARG_TYPE_COMMA(N) CAT(Arg, N) COMMA()
#define ARG_VAR(N) ARG_VAR_NC(N)
#define ARG_VAR_NC(N) CAT(arg, N)
#define ARG_VAR_COMMA(N) CAT(arg, N) COMMA()
#define COMMA() ,
#define ARG_FUNCTION_DECLARATION(N) COMMA() ARG_TYPE(N)
#define ARG_FUNCTION_DECLARATION_COMMA(N) ARG_TYPE(N) COMMA()
#define ARG_FUNCTION_DEFINITION(N) ARG_FUNCTION_DECLARATION(N) ARG_VAR(N)
#define ARG_FUNCTION_DEFINITION_COMMA(N) ARG_TYPE(N) ARG_VAR(N) COMMA()
#define ARG_TEMPLATE_DECLARATION(N) COMMA() typename ARG_TYPE(N)
#define ARG_TEMPLATE_DECLARATION_FIRST(N) ARG_TEMPLATE_DECLARATION(N)##=void
#define FOR(count, id) CAT(FOR_, count)(id, count)
#define FOR_0(id, N) 
#define FOR_1(id, N) FOR_0(id, DEC(N)) id(N)
#define FOR_2(id, N) FOR_1(id, DEC(N)) id(N)
#define FOR_3(id, N) FOR_2(id, DEC(N)) id(N)
#define FOR_4(id, N) FOR_3(id, DEC(N)) id(N)
#define FOR_5(id, N) FOR_4(id, DEC(N)) id(N)
#define FOR_6(id, N) FOR_5(id, DEC(N)) id(N)
#define FOR_7(id, N) FOR_6(id, DEC(N)) id(N)
#define FOR_8(id, N) FOR_7(id, DEC(N)) id(N)
#define FOR_9(id, N) FOR_8(id, DEC(N)) id(N)
#define FOR_10(id, N) FOR_9(id, DEC(N)) id(N)
#define FOR_11(id, N) FOR_10(id, DEC(N)) id(N)
#define FOR_12(id, N) FOR_11(id, DEC(N)) id(N)
#define FOR_13(id, N) FOR_12(id, DEC(N)) id(N)
#define FOR_14(id, N) FOR_13(id, DEC(N)) id(N)
#define FOR_15(id, N) FOR_14(id, DEC(N)) id(N)
#define FOR_16(id, N) FOR_15(id, DEC(N)) id(N)
#define FOR_17(id, N) FOR_16(id, DEC(N)) id(N)
#define FOR_18(id, N) FOR_17(id, DEC(N)) id(N)
#define FOR_19(id, N) FOR_18(id, DEC(N)) id(N)
#define FOR_20(id, N) FOR_19(id, DEC(N)) id(N)
#define OUT_FOR(count, id) CAT(OUT_FOR_, count)(id, count)
#define OUT_FOR_0(id, N) id(N)
#define OUT_FOR_1(id, N) OUT_FOR_0(id, DEC(N)) id(N)
#define OUT_FOR_2(id, N) OUT_FOR_1(id, DEC(N)) id(N)
#define OUT_FOR_3(id, N) OUT_FOR_2(id, DEC(N)) id(N)
#define OUT_FOR_4(id, N) OUT_FOR_3(id, DEC(N)) id(N)
#define OUT_FOR_5(id, N) OUT_FOR_4(id, DEC(N)) id(N)
#define OUT_FOR_6(id, N) OUT_FOR_5(id, DEC(N)) id(N)
#define OUT_FOR_7(id, N) OUT_FOR_6(id, DEC(N)) id(N)
#define OUT_FOR_8(id, N) OUT_FOR_7(id, DEC(N)) id(N)
#define OUT_FOR_9(id, N) OUT_FOR_8(id, DEC(N)) id(N)
#define OUT_FOR_10(id, N) OUT_FOR_9(id, DEC(N)) id(N)
#define OUT_FOR_11(id, N) OUT_FOR_10(id, DEC(N)) id(N)
#define OUT_FOR_12(id, N) OUT_FOR_11(id, DEC(N)) id(N)
#define OUT_FOR_13(id, N) OUT_FOR_12(id, DEC(N)) id(N)
#define OUT_FOR_14(id, N) OUT_FOR_13(id, DEC(N)) id(N)
#define OUT_FOR_15(id, N) OUT_FOR_14(id, DEC(N)) id(N)
#define OUT_FOR_16(id, N) OUT_FOR_15(id, DEC(N)) id(N)
#define OUT_FOR_17(id, N) OUT_FOR_16(id, DEC(N)) id(N)
#define OUT_FOR_18(id, N) OUT_FOR_17(id, DEC(N)) id(N)
#define OUT_FOR_19(id, N) OUT_FOR_18(id, DEC(N)) id(N)
#define OUT_FOR_20(id, N) OUT_FOR_19(id, DEC(N)) id(N)
#define FOR_IN(start, end, id) CAT(FOR_IN_, start)(id, end, end)
#define FOR_IN_0(id, count, start) _BASE_CAT(FOR_, count)(id, start)
#define FOR_IN_1(id, count, start) FOR_IN_0(id, DEC(count), start)
#define FOR_IN_2(id, count, start) FOR_IN_1(id, DEC(count), start)
#define FOR_IN_3(id, count, start) FOR_IN_2(id, DEC(count), start)
#define FOR_IN_4(id, count, start) FOR_IN_3(id, DEC(count), start)
#define FOR_IN_5(id, count, start) FOR_IN_4(id, DEC(count), start)
#define FOR_IN_6(id, count, start) FOR_IN_5(id, DEC(count), start)
#define FOR_IN_7(id, count, start) FOR_IN_6(id, DEC(count), start)
#define FOR_IN_8(id, count, start) FOR_IN_7(id, DEC(count), start)
#define FOR_IN_9(id, count, start) FOR_IN_8(id, DEC(count), start)
#define FOR_IN_10(id, count, start) FOR_IN_9(id, DEC(count), start)
#define FOR_IN_11(id, count, start) FOR_IN_10(id, DEC(count), start)
#define FOR_IN_12(id, count, start) FOR_IN_11(id, DEC(count), start)
#define FOR_IN_13(id, count, start) FOR_IN_12(id, DEC(count), start)
#define FOR_IN_14(id, count, start) FOR_IN_13(id, DEC(count), start)
#define FOR_IN_15(id, count, start) FOR_IN_14(id, DEC(count), start)
#define FOR_IN_16(id, count, start) FOR_IN_15(id, DEC(count), start)
#define FOR_IN_17(id, count, start) FOR_IN_16(id, DEC(count), start)
#define FOR_IN_18(id, count, start) FOR_IN_17(id, DEC(count), start)
#define FOR_IN_19(id, count, start) FOR_IN_18(id, DEC(count), start)
#define FOR_IN_20(id, count, start) FOR_IN_19(id, DEC(count), start)
#define DEC(x) CAT(DEC_, x)
#define DEC_0 0
#define DEC_1 0
#define DEC_2 1
#define DEC_3 2
#define DEC_4 3
#define DEC_5 4
#define DEC_6 5
#define DEC_7 6
#define DEC_8 7
#define DEC_9 8
#define DEC_10 9
#define DEC_11 10
#define DEC_12 11
#define DEC_13 12
#define DEC_14 13
#define DEC_15 14
#define DEC_16 15
#define DEC_17 16
#define DEC_18 17
#define DEC_19 18
#define DEC_20 19
#define BOOL(x) CAT(BOOL_, x)
#define BOOL_0 0
#define BOOL_1 1
#define BOOL_2 1
#define BOOL_3 1
#define BOOL_4 1
#define BOOL_5 1
#define BOOL_6 1
#define BOOL_7 1
#define BOOL_8 1
#define BOOL_9 1
#define BOOL_10 1
#define BOOL_11 1
#define BOOL_12 1
#define BOOL_13 1
#define BOOL_14 1
#define BOOL_15 1
#define BOOL_16 1
#define BOOL_17 1
#define BOOL_18 1
#define BOOL_19 1
#define BOOL_20 1
#define NOT(x) CAT(_NOT_, BOOL(x))
#define _NOT_0 1
#define _NOT_1 0
#define IF(x) CAT(_IF_, BOOL(x))
#define _IF_0(t, ...) __VA_ARGS__
#define _IF_1(t, ...) t
#define VOID_COMMA(N) , void


template <typename ReturnType=void FOR(MAX_CALLBACK_ARGS, ARG_TEMPLATE_DECLARATION_FIRST)> class Callback
{
private:
	void* mThis;
	ReturnType(*mCallback)(void* FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DECLARATION) );
	Callback(void* pThis, ReturnType(*pCallback)(void* FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DECLARATION))) : mThis(pThis), mCallback(pCallback) {}
public:
	Callback() : mThis(nullptr), mCallback(nullptr) {}
	~Callback() {}
	inline ReturnType call(IF(MAX_CALLBACK_ARGS)(FOR(DEC(MAX_CALLBACK_ARGS), ARG_FUNCTION_DEFINITION_COMMA) ARG_TYPE(MAX_CALLBACK_ARGS) ARG_VAR(MAX_CALLBACK_ARGS)))
	{
		return mCallback(mThis FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DEFINITION) );
	}
	template <typename T, ReturnType(T::*Fun)( IF( DEC(MAX_CALLBACK_ARGS) )(FOR( DEC(MAX_CALLBACK_ARGS) , ARG_TYPE_COMMA)) IF(MAX_CALLBACK_ARGS)(ARG_TYPE(MAX_CALLBACK_ARGS)) )> static ReturnType callbackFunction(T* pThis FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DEFINITION) )
	{
		return (pThis->*Fun)( IF( DEC(MAX_CALLBACK_ARGS) )(FOR( DEC(MAX_CALLBACK_ARGS), ARG_VAR_COMMA)) IF(MAX_CALLBACK_ARGS)(ARG_VAR(MAX_CALLBACK_ARGS)) );
	}
	template <typename T, ReturnType(T::*Fun)( IF( DEC(MAX_CALLBACK_ARGS) )(FOR(DEC(MAX_CALLBACK_ARGS), ARG_TYPE_COMMA)) IF(MAX_CALLBACK_ARGS)(ARG_TYPE(MAX_CALLBACK_ARGS)) )> static inline Callback<ReturnType FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DECLARATION) > callback(T* pThis)
	{
		return Callback(static_cast<void*>(pThis), reinterpret_cast<ReturnType(*)(void* FOR(MAX_CALLBACK_ARGS, ARG_FUNCTION_DECLARATION) )>(callbackFunction<T, Fun>));
	}
	inline bool isValid() { return mCallback != nullptr; }
};

template <> class Callback<void FOR(MAX_CALLBACK_ARGS, VOID_COMMA) >
{
private:
	void* mThis;
	void(*mCallback)(void*);
	Callback(void* pThis, void(*pCallback)(void*)) : mThis(pThis), mCallback(pCallback) { }
public:
	Callback() : mThis(nullptr), mCallback(nullptr) {}
	~Callback() {}
	inline void call() { return mCallback(mThis); }
	template <typename T, void(T::*Fun)()> static void callbackFunction(T* pThis) { return (pThis->*Fun)(); }
	template <typename T, void(T::*Fun)()> static inline Callback<> callback(T* pThis) { return Callback(static_cast<void*>(pThis), reinterpret_cast<void(*)()>(callbackFunction<T, Fun>)); }
	inline bool isValid() { return mCallback != nullptr; }
};

#define S1(M)  template<typename ReturnType  
#define S2(M)  FOR(M, ARG_TEMPLATE_DECLARATION) 
#define S3(M) > class Callback<ReturnType 
#define S4(M) FOR(M, ARG_FUNCTION_DECLARATION) 
#define S5(M) FOR_IN(M, MAX_CALLBACK_ARGS, VOID_COMMA) 
#define S6(M) > \
{ \
private: \
	void* mThis;\
	ReturnType(*mCallback)(void* 
#define S7(M) FOR(M, ARG_FUNCTION_DECLARATION) );\
	Callback(void* pThis, ReturnType(*pCallback)(void* FOR(M, ARG_FUNCTION_DECLARATION))) : mThis(pThis), mCallback(pCallback) { } 
#define S8(M) public: \
	Callback() : mThis(nullptr), mCallback(nullptr) {} \
	~Callback() {} \
	inline ReturnType call(
#define S9(M) IF(DEC(M))(FOR(DEC(M), ARG_FUNCTION_DEFINITION_COMMA) ARG_TYPE(DEC(M)) ARG_VAR(DEC(M))) 
#define S10(M) ) \
	{ \
		return mCallback(mThis 
#define S11(M) FOR(M, ARG_FUNCTION_DEFINITION) 
#define S12(M) ); \
	} \
	template <typename T, ReturnType(T::*Fun)( 
#define S13(M) IF(DEC(M))(FOR(DEC(M), ARG_TYPE_COMMA) ARG_TYPE(DEC(M)) ) 
#define S14(M) )> static ReturnType callbackFunction(T* pThis 
#define S15(M) FOR(M, ARG_FUNCTION_DEFINITION) 
#define S16(M)  ) \
	{ \
		return (pThis->*Fun)( 
#define S17(M) IF(DEC(M))(FOR(DEC(M), ARG_VAR_COMMA) ARG_VAR(DEC(M)) ) 
#define S18(M)  ); \
	} \
	template <typename T, ReturnType(T::*Fun)( 
#define S19(M) IF(DEC(M))(FOR(DEC(M), ARG_TYPE_COMMA) ARG_TYPE(DEC(M)) ) 
#define S20(M)  )> static inline Callback<ReturnType 
#define S21(M) FOR(M, ARG_FUNCTION_DECLARATION) 
#define S22(M)  > callback(T* pThis) \
	{ \
		return Callback(static_cast<void*>(pThis), reinterpret_cast<ReturnType(*)(void* 
#define S23(M) FOR(M, ARG_FUNCTION_DECLARATION)
#define S24(M)  )>(callbackFunction<T, Fun>)); \
	} \
	inline bool isValid() { return mCallback != nullptr; } \
};

#define SPECIALIZATION(M) S1(M) S2(M) S3(M) S4(M) S5(M) S6(M) S7(M) S8(M) S9(M) S10(M) S11(M) S12(M) S13(M) S14(M) S15(M) S16(M) S17(M) S18(M) S19(M) S20(M) S21(M) S22(M) S23(M) S24(M) 
IF(MAX_CALLBACK_ARGS)(OUT_FOR(DEC(MAX_CALLBACK_ARGS), SPECIALIZATION))
