#pragma once

#include <cstdint>
#include <vector>
#include <SFML/Graphics.hpp>

class BoundingBox;

class CollisionLayer
{
private:
    int32_t mCollisionMask;
    std::vector<BoundingBox const*> mBoundingBoxes;
public:
    CollisionLayer(void);
    ~CollisionLayer(void);
    void addCollisionWithLayer(unsigned int layer);
    void removeCollisionWithLayer(unsigned int layer);
    void addBoundingBox(BoundingBox const* pBoundingBox);
    void checkCollisions(std::vector<CollisionLayer> const& pLayers);
    void checkCollisions(CollisionLayer const& pLayer, unsigned int pLayerNumber);
    bool checkCollisions(BoundingBox const& pAABB, BoundingBox const*& oCollider);
    bool checkCollisions(sf::Vector2f const& pPosition, BoundingBox const*& oCollider);
    bool removeBoundingBox(BoundingBox const& pAABB);
    void drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const;
};

