#pragma once

#include <vector>
#include <SFML/Graphics.hpp>
#include "BoundingBox.h"
#include "CollisionLayer.h"

class CollisionManager
{
private:
    std::vector<CollisionLayer> mLayers;
    void ensureLayerAvailable(unsigned int pCount);
    BoundingBox mMouseBox;
    bool mWasPressed;
public:
    enum Layers
    {
        GUI = 0,
        MOUSE = 1
    };
    void addLayerCollisions(unsigned int pFirstLayer, unsigned int pSecondLayer);
    void removeLayerCollisions(unsigned int pFirstLayer, unsigned int pSecondLayer);
    void addBoundingBox(unsigned int pLayer, BoundingBox const* pBoundingBox);
    void checkCollisions(sf::Vector2i const& pMousePosition);
    bool checkCollisions(BoundingBox const& pAABB, int32_t pMask, BoundingBox const*& oCollider);
    bool checkCollisions(BoundingBox const& pAABB, BoundingBox const*& oCollider);
    bool checkCollisions(sf::Vector2f const& pPosition, BoundingBox const*& oCollider);
    bool checkCollisions(sf::Vector2f const& pPosition, int32_t pMask, BoundingBox const*& oCollider);
    bool removeBoudingBox(BoundingBox const& pAABB);
    unsigned int removeAllInstancesBoudingBox(BoundingBox const& pAABB);
    bool removeBoudingBox(BoundingBox const& pAABB, unsigned short pLayer);
    void drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const;
    CollisionManager(void);
    ~CollisionManager(void);
};

