#pragma once

#include <vector>
#include <list>
#include <queue>

#include <SFML/System/Vector2.hpp>

struct PathFinderNode
{
    sf::Vector2f position;
    std::vector<std::pair<PathFinderNode*, float> > neighbours;
    PathFinderNode *parent;
    bool isInClosedList;
    bool isInOpenList;
    float bestCost;
};

class PathFinder
{
private:
    std::vector<PathFinderNode> mGraph;

    void resetAStarData();
	void reconstructPath(PathFinderNode &pEndNode, std::list<sf::Vector2f> &oPath);

public:
    PathFinder();
    ~PathFinder();
    
	/// <summary>	insert a node and return its id </summary>
	/// <param name="pScreen"> node's position </param>
	/// <returns> node's id</returns>
    int addNode(sf::Vector2f const &pNodePosition);
    
	/// <summary>  </summary>
	/// <param name="pNodeId">  </param>
	/// <param name="pNeighbourId">  </param>
    void addNodeNeighbour(int pNodeId, int pNeighbourId);
    
	/// <summary>	computes a path and return its length </summary>
	/// <param name="pStartNode"> start node's id </param>
	/// <param name="pEndNode"> End node's id </param>
	/// <param name="oPath"> return parameter containing the path </param>
	/// <returns> path's length</returns>
    float computePath(int pStartNodeId, int pEndNodeId, std::vector<sf::Vector2f> &oPath);
    
	/// <summary>	computes a path and return its length </summary>
	/// <param name="pStartNode"> start node's id </param>
	/// <param name="pEndNode"> End node's id </param>
	/// <param name="oPath"> return parameter containing the path </param>
	/// <returns> path's length</returns>
    float computePath(int pStartNodeId, int pEndNodeId, std::list<sf::Vector2f> &oPath);
    
	/// <summary>	computes the next position on path </summary>
	/// <param name="pStartNode"> start node's id </param>
	/// <param name="pEndNode"> End node's id </param>
	/// <returns> next node on path's position , pStartNode's position if there's no path</returns>
    sf::Vector2f nextPositionOnPath(int pStartNodeId, int pEndNodeId);
};

