#pragma once

#include <SFML/Graphics.hpp>

class Sprite
{
protected:
	sf::Texture *mTexture;
	sf::Sprite *mSprite;
	sf::Image *mImage;
	sf::Image *mCollisionMask;
	std::string mName;

	bool mWasFliped;
	bool mToDelete;

	bool mDeleteTexture;

public:
	Sprite(const std::string& pName = "", const sf::Vector2f pPosition = sf::Vector2f(0,0));
	virtual ~Sprite();
	virtual void update();
	virtual void draw(sf::RenderTarget* pTarget) const;

	virtual void flipX(bool pFlip);

	///-------------------------------------------------------------------------------------------------
	/// <summary>	Retourne une reference vers le sprite </summary>
	///
	/// <returns>	Une reference  vers le sf::Sprite </returns>
	///-------------------------------------------------------------------------------------------------

	sf::Sprite& getSFSprite() const { return *mSprite; }

	///-------------------------------------------------------------------------------------------------
	/// <summary>	Racourcis vers la position </summary>
	///
	/// <returns>	Un sf::Vector2f qui est la position du sprite </returns>
	///-------------------------------------------------------------------------------------------------

	const sf::Vector2f getPosition() const { return mSprite->getPosition(); }

	///-------------------------------------------------------------------------------------------------
	/// <summary>	Test the Mask Collision </summary>
	/// 
	/// <param name="pPosition"> nouvelle position du sprite</param>
	///-------------------------------------------------------------------------------------------------

	void setPosition(const sf::Vector2f &pPosition) { mSprite->setPosition(pPosition); }

	void loadFrom(const sf::String& pFile);

	bool isToDelete() { return mToDelete; }
};