#pragma once

#include <map>
#include <SFML/System.hpp>
#include <SFML/Graphics.hpp>

struct TextureAsset
{
	sf::Texture* texture;
	sf::String path;
	int counter;
};

class TextureDatabase
{
protected:
	static TextureDatabase* sInstance;

	std::map<sf::String, TextureAsset*> mAssets;
	std::map<sf::Texture*, TextureAsset*> mLinked; // allow to find a texture asset by its texture

public:

	static sf::Texture* load(const sf::String& pPath);
	static void unload(sf::Texture* pTexture);
};