#include "CreditsScreen.h"
#include "HomeScreen.h"
#include "Config.h"

CreditsScreen::CreditsScreen(void) : mSprite("data/home/credits.png"), mWasPressed(false)
{
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
    mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);
    mButton = Button("Back", mFont);
	mButton.setPosition(sf::Vector2f(0, 700));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
}


CreditsScreen::~CreditsScreen(void)
{
}

void CreditsScreen::update()
{
	mButton.update();
	if (mButton.isClicked())
	{
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(new HomeScreen());
	}
}

void CreditsScreen::draw(sf::RenderTarget* pTarget)
{
    mSprite.draw(pTarget);
	mButton.draw(pTarget);
}
