#pragma once

#include "engine/AScreen.h"
#include "network/Network.h"
#include "engine/Sprite.h"
#include "Config.h"
#include "engine/Button.h"
class Sprite;

class HomeScreen :
    public AScreen
{
private:
    sf::Font mFont;
    Sprite mBackground;
    std::unique_ptr<Network> mNetwork;
    std::vector<std::pair<Button, void(HomeScreen::*)(void)> > mButtons;
    void lan();
    void join();
    void host();
    void serv();
    void credits();
    void alone();
public:
	HomeScreen(float pScreenWidth = Config::Graphics::width, float pScreenHeight = Config::Graphics::height);
    ~HomeScreen(void);

	virtual void update();
	virtual void draw(sf::RenderTarget* pTarget);
};

