#pragma once
#include <SFML/Network.hpp>
#include "engine/AScreen.h"
#include <cstdint>

class Network
{
private:
    enum MessageType {
        GAME_TYPE,
        READY,
        REPLAY,
        QUIT,
        WIN,
        PLATFORMER_HEIGHT,
        PLATFORMER_EAT,
        STR_KILL_MEMBER,
        STR_MEMBER_LIFE
    };
    std::unique_ptr<sf::TcpSocket> mSocket;
    bool mGameToPlay;
    void checkConnection(sf::Socket::Status pStatus);
    bool receiveMessage(sf::Packet& oPacket);
    bool waitMessage(sf::Packet& oPacket);
    bool mIsOtherReady;
    bool mIsOtherReplaying;
    bool mIsDisconnected;
public:
    enum Member {
        HEAD,
        LEFT_LEG,
        RIGHT_LEG,
        LEFT_ARM,
        RIGHT_ARM,
        HEART
    };
    class Message {
    private:
        MessageType mType;
        union {
            bool mBool;
            uint8_t mUint8;
            float mFloat;
        } mFirst;
        union {
            bool mBool;
            uint8_t mUint8;
            float mFloat;
        } mSecond;
        Message(sf::Packet& pPacket);
    public:
        Message();
        ~Message();
        bool isForRtsPlayer();
        bool isForPlateformerPlayer();
        bool isSystem();
        bool isGameType();
        bool getGameType();
        bool isEat();
        bool isHeight();
        bool isMemberKill();
        bool isMemberLife();
        bool isWin();
        Member getMember();
        float getCholesterol();
        float getLife();
        float getHeight();
        friend class Network;
    };
    bool isDisconnected();
    void platformerSendHeight(float pHeight);
    void platformerEaten(float pCholesterol);
    void platformerVictory();
    void strKillMember(Member pMember);
    void strSendMemberLife(Member pMember, float pState);
    void strVictory();
    bool getMessage(Network::Message& oMessage);
    int getOneMessage(Network::Message& oMessage);
    bool replay();
    void ready();
	bool isOtherReady();
    void quit();
	bool isReady();
    bool nextGameKind();
    Network(std::unique_ptr<sf::TcpSocket> pSocket, bool hasOwnership = false);
    Network(std::unique_ptr<sf::TcpSocket> pSocket, sf::Packet& pPacket);
    ~Network(void);
};
