#pragma once

#include "engine/Sprite.h"
#include "engine/BoundingBox.h"

class PlatformerScreen;

class Collectible : public Sprite, public BoundingBox
{
private:
    int mEnergyValue;
    int mCholesterolValue;
    PlatformerScreen* mPlatformerScreen;
    int mSpriteIndex;

    float mInstantiationStartTime;
    float mInitialY;
public:
	Collectible(const std::string& pSpriteName, int pEnergyValue, int pCholesterolValue, PlatformerScreen* pPlatformerScreen, int pSpriteIndex);
	virtual ~Collectible();

    virtual void update();
	virtual void draw(sf::RenderTarget* pTarget) const;
    void setPosition(sf::Vector2f pPos);
    int getEnergyValue() const {return mEnergyValue; }
    int getCholesterolValue() const { return mCholesterolValue; }
    void removeFromList() const;
};