#pragma once

#include "engine/AnimatedSprite.h"
#include "engine/BoundingBox.h"

class PlatformerScreen;
class Platform;

class Enemy : public AnimatedSprite, public BoundingBox
{
private:
    Platform* mSupportingPlatform;
    float mLife;
    PlatformerScreen* mPlatformerScreen;
    int mSpriteIndex;
    void setPosition(sf::Vector2f pPos);
    float mDeltaMove;

public:
	Enemy(Platform* mSupportingPlatform, PlatformerScreen* pPlatformerScreen, int pSpriteIndex);
    bool tryKill(float damage);
	virtual ~Enemy();

    virtual void update();
	virtual void draw(sf::RenderTarget* pTarget) const;
    void removeFromList() const;
};