#pragma once

#include <vector>
#include <SFML/Audio.hpp>

#include "engine/AScreen.h"
#include "../engine/CollisionManager.h"
#include "network/Network.h"
#include "Config.h"

class Player;
class Sprite;

#define TIME_SEND_INFO 0.1f

class PlatformerScreen : public AScreen
{
private:
    float mScreenWidth;
    float mScreenHeight;
	float mTimeInfoSend;
    Player* mPlayer;
    std::vector<Sprite*> mSprites;
    CollisionManager mCollisionManager;
    sf::Music mMusic;
    std::unique_ptr<Network> mNetwork;
    void onVictory();
    
    sf::SoundBuffer mVictorySoundBuffer;
    sf::Sound mVictorySound;

public:
	PlatformerScreen(std::unique_ptr<Network> pNetwork = nullptr, float pScreenWidth = Config::Graphics::width, float pScreenHeight = Config::Graphics::height);
    ~PlatformerScreen(void);
    
	virtual void update();
	virtual void draw(sf::RenderTarget* pTarget);
    void hasEaten(float pCholesterol);
    void removeSprite(int pSpriteIndex);
};

