#pragma once

#define TIME_TO_BE_HURT 1
#define NOISE_PARTICLES_COUNT 128

#include <SFML/Audio.hpp>

#include "engine/AnimatedSprite.h"
#include "engine/BoundingBox.h"
#include "engine/CollisionManager.h"
#include "network/Network.h"
class Enemy;
class Collectible;
class PlatformerScreen;

class Player : public AnimatedSprite
{
private:
    PlatformerScreen& mPlatformerScreen;
    CollisionManager& mCollisionManager;
    BoundingBox mGroundAABB;
    BoundingBox mPlayerHittenAABB;
    BoundingBox mPlayerHittingAABB;
    sf::Vector2f mVelocity;
    bool mIsGrounded;
    float mTimeHurt;
    float mEnergy;
    bool mIsRecovering;
    std::vector<std::pair<sf::SoundBuffer*, sf::Sound*> > mEatSounds;
    std::vector<std::pair<sf::SoundBuffer*, sf::Sound*> > mJumpSounds;
    std::vector<std::pair<sf::SoundBuffer*, sf::Sound*> > mHurtSounds;
    std::pair<sf::SoundBuffer*, sf::Sound*> mSickLoop;
    
    void playEatSound();
    void playJumpSound();
    void playHurtSound();
    void playSickSound();
    void stopSickSound();

    int mPreviousInputsMask;
    enum InputEnum
    {
        LEFT,
        RIGHT,
        JUMP,
        HIT
    };
    int getInputMask() const;
    
    enum BodyPartEnum
    {
        HEAD,
        LEFT_LEG,
        RIGHT_LEG,
        LEFT_ARM,
        RIGHT_ARM,
        HEART,
        BODY_PARTS_CARD
    };
	enum BodyPartLife
	{
		KILLED = 0,
		CRITIC,
		VERY_LOW,
		LOW,
		ACCEPTABLE,
		HIGH,
		FULL
	};
    BodyPartLife mBodyState[BODY_PARTS_CARD];
    float mScreenWidth;

    struct PlayerGUI
    {
        Sprite mBodySprite;
        Sprite mIllBodyParts[BODY_PARTS_CARD];
        Sprite mNoiseSprites[NOISE_PARTICLES_COUNT];
        Sprite mEnergyUnit;
        Sprite mEnergyGaugeframe;
        Sprite mEnergyGaugeBase;
        Sprite mEnergyGaugeFull;
    };
    PlayerGUI mGUI;

    void groundBelow(BoundingBox const& pCollider, unsigned int pLayer);
    void enemyTouched(BoundingBox const& pCollider);
    void enemyHit(BoundingBox const& pCollider);
    void collect(BoundingBox const& pCollider);
    void destroyCollectible(Collectible const* pCollectible);
    void destroyEnemy(Enemy const* pEnemy);
    void baseGroundBelow(BoundingBox const& pCollider);
    void setPosition(sf::Vector2f const& pPosition);
    std::vector<Collectible const*> mCollectiblesToDestroy;
    std::vector<Enemy const*> mEnemiesToDestroy;
	static BodyPartLife getBodyPartLife(float pLife);
	static uint8_t getOpacity(BodyPartLife pLife);
public:
    Player(const sf::Vector2f& pInitPosition, float pScreenWidth, CollisionManager& pCollisionManager, PlatformerScreen& pPlatformerScreen);
	virtual ~Player();
    
    float mVictoryCoolDown;
    void killMember(Network::Member pBodyPart);
    void updateLife(Network::Member pBodyPart, float pLife);
    virtual void update();
	virtual void draw(sf::RenderTarget* pTarget) const;
};