#pragma once

#include <list>

#include "engine/PathFinder.h"

#include "str/BodyGridCell.h"
#include "str/STRObject.h"

class BodyGrid
{

protected:
	BodyGridCell* mGrid;
	int	mWidth;
	int mHeight;

	std::list<STRObject*> mObjects;
	std::list<STRObject*> mObjToDelete;

	PathFinder mPathfinder;

public:
	BodyGrid();

	void init(int pWidth, int pHeight);
	void fromFile(const sf::String& pFile);

	void initPathFinder();

	void update();
	void draw(sf::RenderTarget* pTarget) const;

	BodyGridCell* getAt(int i, int j);
	BodyGridCell* getAtWorld(sf::Vector2f pWorldPos);

	sf::Vector2i getCellIdxFromWorld(sf::Vector2f pWorldPos);

	sf::Vector2i getSize();

	void registerObject(STRObject* pObject, int i, int j);
	void unregisterObject(STRObject* pObject);

	std::list<STRObject*>* getObjects();

	PathFinder* getPathfinder();
};