#pragma once

#include <list>

#include "engine/AnimatedSprite.h"

class Unit;
class BodyGrid;

class BodyGridCell : public AnimatedSprite
{
public:
	enum Type{GROUND, WALL};

protected:
	Type mType;
	std::list<Unit*> mUnits;
	bool mPassable;

	BodyGrid* mGrid;
	sf::Vector2i mIdx;

	bool mVisited;

	float mFat;

	int mId;

	sf::RectangleShape mRect;

public:
	BodyGridCell();

	void setType(Type pType);
	void registerUnit(Unit* pUnit);
	void unregisterUnit(Unit* pUnit);

	void update();
	void draw(sf::RenderTarget* pTarget) const;

	bool isPassable() const;
	void setPassable( bool pPassable);

	void increaseFatification(float pAmount);
	float getFat();

	void setGrid(int i, int j, BodyGrid* pGrid);

	sf::Vector2i getIndex();

	bool isVisited() const;
	void setVisited(bool pVisited);

	int getId() const;
	void setId(int pId);
};