#pragma once

#include "engine/AnimatedSprite.h"

class Unit;
class BodyGrid;

class STRObject : public AnimatedSprite
{
protected:
	sf::Vector2f mCenter;

	BodyGrid* mGrid;
	float mRange;
	sf::Vector2i mIndex;

public:
	virtual void use(Unit* pUnit) = 0;

	virtual void onPlaced(BodyGrid* Grid, int i, int j) = 0;

	float getRange() { return mRange; }

	sf::Vector2f getCenter() { return mCenter; }
	void setCenter(sf::Vector2f pCenter) { mCenter = pCenter; }

	void setGrid(BodyGrid* pGrid) { mGrid = pGrid; }
	BodyGrid* getGrid() { return mGrid; }
};