#pragma once

#include <list>

#include <SFML/Audio.hpp>

#include "engine/AScreen.h"
#include "str/BodyGrid.h"
#include "str/Unit.h"
#include "str/units/Leucocyte.h"
#include "network/Network.h"

class STRScreen : public AScreen
{
private:
    unsigned short mKilledMembers;
    std::unique_ptr<Network> mNetwork;
	BodyGrid mGrid;

	std::list<Unit*> mUnits;

	std::list<Leucocyte*> mEnnemies;

	Unit* mCurrentUnit;
	sf::RectangleShape mSelectRect;
	bool mLeftPressed;
	sf::Vector2i mSpawn;

	//------- INFO SPAWN

	std::vector<sf::IntRect> mFatSpawn;
	std::vector<sf::IntRect> mLeucocyteSpawn;

	//------------------

	bool mMoveCamera;
	sf::Vector2i mLastMousePos;
	float mZoom;

	//--energy
	float mEnergy;
	sf::Text mEnergyText;

	float mGoodEnergy;
	sf::Text mGoodEnergyText;

	float mHeight;
	sf::Text mHeightText;

	float mGrasSpawn;

	bool mSpawnKey[2]; //0 gatherer, 1 fighter

	sf::Music mMusic;

public:

	STRScreen(std::unique_ptr<Network> pNetwork = nullptr);

	void update();
	void draw(sf::RenderTarget* pTarget);

	void cameraHandling();

	bool checkSelection();
	void manageInput();

	void spawnFatUnit();
	void spawnFatFighter();
	void spawnFat();

	void spawnLeucocyte();

	void fromFolder(const sf::String& pFolder);
	
    void killMember(Network::Member pMember);
    void sendLife(Network::Member pMember, float pLife);
};