#pragma once

#include <SFML/Audio.hpp>

#include "engine/AnimatedSprite.h"
#include "str/BodyGrid.h"

class Unit : public AnimatedSprite
{
protected:
	static sf::SoundBuffer* sBuffer;

	sf::Sound sound;


	BodyGrid* mGrid;
	BodyGridCell* mCase;

	sf::Vector2i mTarget;
	bool mMustMove;

	std::vector<sf::Vector2f> mPath;

	bool mAtTarget;
	sf::Vector2f mCurrentToward;

	bool mCaseChanged;
	bool mDead;

	bool mBlocked; //use to define if the unit can move

	int mCurrentPathIdx;

	float mSpeed;

	float mSinceLastHurt;

	int mReferenced;

	float mHealth;
	float mMaxHealth;
	sf::RectangleShape mHealthBar;

public:
	Unit();

	void update();
	void draw(sf::RenderTarget* pTarger) const;

	void setGrid(BodyGrid* pGrid);
	void setCase(int i, int j);

	void gotoCase(int i, int j);

	void checkObjectUse();

	bool caseChanged();

	bool isBlocked() const;
	void block(bool pBlock);

	void hurt(float pDamage);

	virtual void die();
	bool isDead() const;

	void reference();
	void unreference();
	int getReference() const ;
};