#pragma once

#include "str/STRObject.h"

#include "str/BodyGridCell.h"

#include "network/Network.h"

#define TIME_TO_SEND_LIFE 1.0f

class FatFactory : public STRObject
{
private:
	float mTimeToSendLife;
protected:
	float mFat;
	float mFatMax;

	std::list<BodyGridCell*> mToFatify;

	std::list<BodyGridCell*> mToAdd;
	std::list<BodyGridCell*> mToRemove;

	int mCellFatified;
	bool mWorking;

	Network::Member mMember;

	sf::RectangleShape mFatBar;

public:
	FatFactory();

	void addFat(float pAmount);

	void setMember(int pNum);

	void use(Unit* pUnit);

	void onPlaced(BodyGrid* Grid, int i, int j);

	void update();
	void draw(sf::RenderTarget* pTarget) const;

	void addToFatification(int i, int j);
	void fatification(float pAmount);

	void fatificationComplete();
};