#include "Config.h"

int Config::Graphics::width = 600;
int Config::Graphics::height = 800;

float Config::PlatformerPlayer::maxEnergy = 100.0f;
float Config::PlatformerPlayer::consumedEnergyOnJump = 5.0f;
float Config::PlatformerPlayer::consumedEnergyPerSecondOnMove = 5.0f;
float Config::PlatformerPlayer::consumedEnergyPerSecondOnHit = 5.0f;
float Config::PlatformerPlayer::gainedEnergyPerSecondOnRecovery = 5.0f;
float Config::PlatformerPlayer::recoveredEnergyOnRecovery = 50.0f;

sf::Vector2f Config::PlatformerPlayer::gravity(0.0f, 50.0f);

float Config::PlatformerPlayer::horizontalAirFriction = 100.0f;
float Config::PlatformerPlayer::horizontalGroundFriction = 200.0f;

float Config::PlatformerPlayer::twoLegsJumpImpulse = -200.0f;
float Config::PlatformerPlayer::oneLegJumpImpulse = -150.0f;
float Config::PlatformerPlayer::noLegJumpImpulse = -100.0f;

float Config::PlatformerPlayer::twoLegsHorizontalAcceleration = 200.0f;
float Config::PlatformerPlayer::oneLegHorizontalAcceleration = 150.0f;
float Config::PlatformerPlayer::noLegHorizontalAcceleration = 100.0f;

float Config::PlatformerPlayer::twoLegsMaxHorizontalVelocity = 200.0f;
float Config::PlatformerPlayer::oneLegMaxHorizontalVelocity = 150.0f;
float Config::PlatformerPlayer::noLegMaxHorizontalVelocity = 100.0f;

float Config::PlatformerPlayer::twoArmsHitDamage = 150.0f;
float Config::PlatformerPlayer::oneArmHitDamage = 75.0f;
float Config::PlatformerPlayer::twoArmsHitDuration = 0.0625f;
float Config::PlatformerPlayer::oneArmHitDuration = 0.5f;

float Config::PlatformerPlayer::hitCoolDown = 0.5f;

float Config::PlatformerEnemy::speed = 50.0f;
float Config::PlatformerEnemy::life = 75.0f;
int Config::PlatformerEnemy::maxHeight = 192;
int Config::PlatformerEnemy::commestibles = 384;

float Config::Str::energyPerCholesterol = 1.f;
float Config::Str::goodEnergyPerCholesterol = 0.f;
float Config::Str::grasPerCholesterol = -.2f;
float Config::Str::energyPerNegativeCholesterol = -.25f;
float Config::Str::goodEnergyPerNegativeCholesterol = .25f;
float Config::Str::grasPerNegativeCholesterol = 0.f;
float Config::Str::multiplierGatherAmount = 5.f;
float Config::Str::multiplierGrasSpeed = 5.f;

unsigned short Config::Network::udpReadPort;
unsigned short Config::Network::udpWritePort;
unsigned short Config::Network::tcpPort;
unsigned int Config::Network::lookupLiveTime;
sf::IpAddress Config::Network::serverAddress;
std::string Config::Network::logMessage;

void Config::LoadFromFile(const char* pFile)
{
	Graphics::width = atoi(INIFile::GetValue("width", "Graphics", pFile).c_str());
	Graphics::height = atoi(INIFile::GetValue("height", "Graphics", pFile).c_str());
        
    PlatformerPlayer::gravity = sf::Vector2f(0.0f, (float) atof(INIFile::GetValue("gravityOnY", "PlatformerPlayer", pFile).c_str()));
        
    PlatformerPlayer::horizontalGroundFriction = (float) atof(INIFile::GetValue("horizontalGroundFriction", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::horizontalAirFriction = (float) atof(INIFile::GetValue("horizontalAirFriction", "PlatformerPlayer", pFile).c_str());

    PlatformerPlayer::twoLegsJumpImpulse = (float) atof(INIFile::GetValue("twoLegsJumpImpulse", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::oneLegJumpImpulse = (float) atof(INIFile::GetValue("oneLegJumpImpulse", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::noLegJumpImpulse = (float) atof(INIFile::GetValue("noLegJumpImpulse", "PlatformerPlayer", pFile).c_str());

    PlatformerPlayer::twoLegsHorizontalAcceleration = (float) atof(INIFile::GetValue("twoLegsHorizontalAcceleration", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::oneLegHorizontalAcceleration = (float) atof(INIFile::GetValue("oneLegHorizontalAcceleration", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::noLegHorizontalAcceleration = (float) atof(INIFile::GetValue("noLegHorizontalAcceleration", "PlatformerPlayer", pFile).c_str());

    PlatformerPlayer::twoLegsMaxHorizontalVelocity = (float) atof(INIFile::GetValue("twoLegsMaxHorizontalVelocity", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::oneLegMaxHorizontalVelocity = (float) atof(INIFile::GetValue("oneLegMaxHorizontalVelocity", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::noLegMaxHorizontalVelocity = (float) atof(INIFile::GetValue("noLegMaxHorizontalVelocity", "PlatformerPlayer", pFile).c_str());
    
    PlatformerPlayer::twoArmsHitDamage = (float) atof(INIFile::GetValue("twoArmsHitDamage", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::oneArmHitDamage = (float) atof(INIFile::GetValue("oneArmHitDamage", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::twoArmsHitDuration = (float) atof(INIFile::GetValue("twoArmsHitDuration", "PlatformerPlayer", pFile).c_str());
    PlatformerPlayer::oneArmHitDuration = (float) atof(INIFile::GetValue("oneArmHitDuration", "PlatformerPlayer", pFile).c_str());
    
    PlatformerPlayer::hitCoolDown = (float) atof(INIFile::GetValue("hitCoolDown", "PlatformerPlayer", pFile).c_str());
    
    PlatformerEnemy::speed = (float) atof(INIFile::GetValue("speed", "PlatformerEnemy", pFile).c_str());
    PlatformerEnemy::life = (float) atof(INIFile::GetValue("life", "PlatformerEnemy", pFile).c_str());
    PlatformerEnemy::commestibles = (int) atoi(INIFile::GetValue("commestibles", "PlatformerEnemy", pFile).c_str());
    PlatformerEnemy::maxHeight = (int) atoi(INIFile::GetValue("maxHeight", "PlatformerEnemy", pFile).c_str());
    
    Network::tcpPort = (unsigned short) atoi(INIFile::GetValue("tcpPort", "Network", pFile).c_str());
    Network::udpReadPort = (unsigned short) atoi(INIFile::GetValue("udpReadPort", "Network", pFile).c_str());
    Network::udpWritePort = (unsigned short) atoi(INIFile::GetValue("udpWritePort", "Network", pFile).c_str());
    Network::logMessage = INIFile::GetValue("logMessage", "Network", pFile);
    Network::serverAddress = INIFile::GetValue("serverAddress", "Network", pFile);

    Config::Str::energyPerCholesterol = (float) atof(INIFile::GetValue("energyPerCholesterol", "Str", pFile).c_str());
    Config::Str::goodEnergyPerCholesterol = (float) atof(INIFile::GetValue("goodEnergyPerCholesterol", "Str", pFile).c_str());;
    Config::Str::grasPerCholesterol = (float) atof(INIFile::GetValue("grasPerCholesterol", "Str", pFile).c_str());;
    Config::Str::energyPerNegativeCholesterol = (float) atof(INIFile::GetValue("energyPerNegativeCholesterol", "Str", pFile).c_str());;
    Config::Str::goodEnergyPerNegativeCholesterol = (float) atof(INIFile::GetValue("goodEnergyPerNegativeCholesterol", "Str", pFile).c_str());;
    Config::Str::grasPerNegativeCholesterol = (float) atof(INIFile::GetValue("grasPerNegativeCholesterol", "Str", pFile).c_str());;
    Config::Str::multiplierGatherAmount = (float) atof(INIFile::GetValue("multiplierGatherAmount", "Str", pFile).c_str());;
    Config::Str::multiplierGrasSpeed = (float) atof(INIFile::GetValue("multiplierGrasSpeed", "Str", pFile).c_str());;
}