#pragma once

#include "engine/Animation.h"

#include "engine/GameTime.h"
#include <dirent.h>

#include "engine/AnimatedSprite.h"

#include "engine/TextureDatabase.h"

Animation::Animation(AnimatedSprite* pSprite, const sf::String& pName,  const sf::String& pPath, float pSpeed, bool pLoop)
{
	mName = pName;

	mSprite = pSprite;
	mSpeed = pSpeed;
	mStart = false;

	mLoop = pLoop;

	DIR *lDir;
	struct dirent *ent;
	sf::Texture *lTexture = new sf::Texture();
	//sf::Image *lImage;
	std::string lPath = pPath;

	// *********** IMAGE LOADING ****/////////////////////////
	lDir = opendir (lPath.c_str());

	if (lDir != NULL) 
	{
		for(int i =0;i=mListTexture.size();++i)
		{
			TextureDatabase::unload(mListTexture.at(i));
		}

	  /* print all the files and directories within directory */
	  while ((ent = readdir (lDir)) != NULL) 
	  {
		  if(ent->d_type == DT_REG)
		  {
			  sf::String lStr(ent->d_name);
			  if(lStr.find(".png") != sf::String::InvalidPos || lStr.find(".jpg") != sf::String::InvalidPos)
			  {
				  /*lTexture = new sf::Texture();
				  lTexture->loadFromFile(pPath+"/"+sf::String(ent->d_name));
				  mListTexture.push_back(lTexture);*/

				  lTexture = TextureDatabase::load(pPath+"/"+sf::String(ent->d_name));
				  mListTexture.push_back(lTexture);
			  }
		  }
	  }
	  closedir (lDir);

	  mTempsFrame = mSpeed / mListTexture.size();
	} 
	else 
	{
	  /* could not open directory */
	  perror ("could not open directory");
	  return;
	}

	//------------------------------------------------------------

	mSprite->mSprite->setTexture(*mListTexture.at(0));
}

Animation::~Animation()
{
	for(unsigned int i = 0; i < mListTexture.size(); ++i)
	{
		TextureDatabase::unload(mListTexture.at(i));
	}

	for(unsigned int i = 0; i < mMaskList.size(); ++i)
	{
		delete mMaskList.at(i);
	}
}

//--------------------------------------------


void Animation::update()
{
	bool mWasChanged = false;

	if(mStart)
	{

		mTimeStart += Time::deltaTime();


		while(mTimeStart > mTempsFrame)
		{
			mCurrentFrame++;
			mWasChanged = true;
			if(mCurrentFrame >= (int)mListTexture.size())
			{
				if(mLoop)
					mCurrentFrame = 0;
				else
				{
					mCurrentFrame = mListTexture.size() - 1;
					mStart = false;
					return;
				}
			}

			mTimeStart -= mTempsFrame;
		}
	}

	setFrame(mCurrentFrame);
}


//--------------------------------------------

void Animation::play()
{
	mTimeStart = 0;
	mCurrentFrame = 0;
	mStart = true;
}

//--------------------------------------------

void Animation::stop()
{
	mStart = false;
}

//----------------------------------------------

void Animation::setFrame(int pFrame)
{
	mSprite->mSprite->setTexture(*mListTexture.at(pFrame), false);

	if(mSprite->mWasFliped)
	{
		mSprite->mSprite->setOrigin((float)mSprite->mSprite->getTextureRect().width, 0);
		//mSprite->mCollisionMask->FlipHorizontally();
	}
}

//----------------------------------------------

void Animation::flip()
{
	/*for(int i = 0; i < mMaskList.size(); i++)
	{
		mMaskList[i]->FlipHorizontally();
	}*/
}