#include "..\..\include\engine\BoundingBox.h"

BoundingBox::BoundingBox(void)
{
}

BoundingBox::~BoundingBox(void)
{
}

BoundingBox::BoundingBox(float pWidth, float pHeight, float pLeft, float pTop) : mRect(pLeft, pTop, pWidth, pHeight)
{
}

BoundingBox::BoundingBox(sf::Vector2f const& pSize) : mRect(0, 0, pSize.x, pSize.y)
{
}

BoundingBox::BoundingBox(sf::Vector2f const& pSize, sf::Vector2f const& pPos) : mRect(pPos.x, pPos.y, pSize.x, pSize.y)
{
}

sf::Vector2f BoundingBox::getBoxPosition() const
{
    return sf::Vector2f(mRect.left, mRect.top);
}

sf::Vector2f BoundingBox::getBoxSize() const
{
    return sf::Vector2f(mRect.width, mRect.height);
}

sf::Rect<float> const& BoundingBox::getBoxRect() const
{
    return mRect;
}

void BoundingBox::setBoxPosition(float pLeft, float pTop)
{
    mRect.left = pLeft;
    mRect.top = pTop;
}

void BoundingBox::setBoxPosition(sf::Vector2f const& pPos)
{
    setBoxPosition(pPos.x, pPos.y);
}

void BoundingBox::setBoxSize(float pWidth, float pHeight)
{
    mRect.width = pWidth;
    mRect.height = pHeight;
}

void BoundingBox::setBoxSize(sf::Vector2f const& pPos)
{
    setBoxSize(pPos.x, pPos.y);
}

bool BoundingBox::testCollision(BoundingBox const& pAABB) const
{
    if (&pAABB == this) return false;
    return this->mRect.intersects(pAABB.mRect);
}

bool BoundingBox::testCollision(sf::Vector2f const& pPosition) const
{
    return this->mRect.contains(pPosition);
}

void BoundingBox::checkCollisions(std::vector<BoundingBox const*> const& pBoundingBoxes, unsigned int pLayer) const
{
    for (int i = 0, l = pBoundingBoxes.size() ; i < l ; ++i)
    {
        if (testCollision(*pBoundingBoxes[i]))
        {
            callCallback(*pBoundingBoxes[i], pLayer);
        }
    }
}

void BoundingBox::callCallback(BoundingBox const& pCollider, unsigned int pLayer) const
{
    std::map<unsigned int, std::pair<void(*)(void*, BoundingBox const&, unsigned int), void*>>::const_iterator iter = mCallbackLayers.find(pLayer);
    if (iter != mCallbackLayers.end())
    {
        (*iter).second.first((*iter).second.second, pCollider, pLayer);
    }
    else if (mCallback && mCallbackThis)
    {
        mCallback(mCallbackThis, pCollider, pLayer);
    }
}

void BoundingBox::drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const
{
    sf::RectangleShape lShape(sf::Vector2f(mRect.width, mRect.height));
    lShape.setPosition(mRect.left, mRect.top);
    lShape.setFillColor(color);
    lShape.setOutlineColor(color);
    pTarget.draw(lShape);
}
