#include "engine/Button.h"
#include "engine/ScreenManager.h"

Button::Button(std::string const& pString, sf::Font const& pFont, bool pIsButton, unsigned int pCharacterSize) : mText(pString, pFont), mIsHover(false), mIsPressed(false), mWasPressed(false), mHasColorActive(pIsButton), mHasColorHover(false), mHasStyleActive(pIsButton), mHasStyleHover(pIsButton), mHasCharacterSizeHover(pIsButton), mHasCharacterSizeActive(pIsButton), mCharacterSize(pCharacterSize), mStyle(sf::Text::Regular), mStyleHover(sf::Text::Bold), mStyleActive(sf::Text::Bold), mCharacterSizeActive(36U), mCharacterSizeHover(36U), mColorActive(sf::Color::Red), mColor(sf::Color::White), mColorHover(sf::Color::White)
{
	updatePosition();
}

void Button::updatePosition()
{
	sf::Vector2i mousePos = sf::Mouse::getPosition(*ScreenManager::getInstance()->getWin());
	mIsHover = (mousePos.x <= mPosition.x + mSize.x && mousePos.x >= mPosition.x && mousePos.y <= mPosition.y + mSize.y && mousePos.y >= mPosition.y);
	if (mIsHover && mIsPressed)
	{
		mText.setColor(mHasColorActive ? mColorActive : mColor);
		mText.setStyle(mHasStyleActive ? mStyleActive : mStyle);
		mText.setCharacterSize(mHasCharacterSizeActive ? mCharacterSizeActive : mCharacterSize);
	}
	else if (mIsHover)
	{
		mText.setColor(mHasColorHover ? mColorHover : mColor);
		mText.setStyle(mHasStyleHover ? mStyleHover : mStyle);
		mText.setCharacterSize(mHasCharacterSizeHover ? mCharacterSizeHover : mCharacterSize);
	}
	else
	{
		mText.setColor(mColor);
		mText.setStyle(mStyle);
		mText.setCharacterSize(mCharacterSize);
	}
	sf::FloatRect lBounds = mText.getGlobalBounds();
	mText.setPosition(mPosition + (mSize - sf::Vector2f(lBounds.width, lBounds.height)) / 2.f);
}

void Button::update()
{
	mWasPressed = mIsPressed;
	mIsPressed = sf::Mouse::isButtonPressed(sf::Mouse::Left);
	updatePosition();
}

bool Button::isClicked()
{
	return mIsHover && mWasPressed && !mIsPressed;
}

void Button::draw(sf::RenderTarget* pTarget)
{
	pTarget->draw(mText);
}
