#include "..\..\include\engine\CollisionLayer.h"
#include "..\..\include\engine\BoundingBox.h"

CollisionLayer::CollisionLayer(void) : mCollisionMask(0)
{
}


CollisionLayer::~CollisionLayer(void)
{
}

void CollisionLayer::addCollisionWithLayer(unsigned int pLayer)
{
    mCollisionMask |= (1 << pLayer);
}

void CollisionLayer::removeCollisionWithLayer(unsigned int pLayer)
{
    mCollisionMask &= ~(1 << pLayer);
}

void CollisionLayer::addBoundingBox(BoundingBox const* pBoundingBox)
{
    mBoundingBoxes.push_back(pBoundingBox);
}

void CollisionLayer::checkCollisions(std::vector<CollisionLayer> const& pLayers)
{
    int32_t iCollisionMask = mCollisionMask;
    for (unsigned int iLayerAct = 0, lLayerCount = pLayers.size() ; iLayerAct < lLayerCount && iCollisionMask ; ++iLayerAct, iCollisionMask >>= 1)
    {
        if (iCollisionMask & 0x1)
        {
            checkCollisions(pLayers[iLayerAct], iLayerAct);
        }
    }
}

void CollisionLayer::checkCollisions(CollisionLayer const& pLayer, unsigned int pLayerNumber)
{
    for (int i = 0, l = mBoundingBoxes.size() ; i < l ; ++i)
    {
        mBoundingBoxes[i]->checkCollisions(pLayer.mBoundingBoxes, pLayerNumber);
    }
}

bool CollisionLayer::checkCollisions(BoundingBox const& pAABB, BoundingBox const*& oCollider)
{
    for (int i = 0, l = mBoundingBoxes.size() ; i < l ; ++i)
    {
        if (mBoundingBoxes[i]->testCollision(pAABB))
        {
            oCollider = mBoundingBoxes[i];
            return true;
        }
    }
    return false;
}

bool CollisionLayer::checkCollisions(sf::Vector2f const& pPosition, BoundingBox const*& oCollider)
{
    for (int i = 0, l = mBoundingBoxes.size() ; i < l ; ++i)
    {
        if (mBoundingBoxes[i]->testCollision(pPosition))
        {
            oCollider = mBoundingBoxes[i];
            return true;
        }
    }
    return false;
}

#include <iostream>

bool CollisionLayer::removeBoundingBox(BoundingBox const& pAABB)
{
    std::vector<BoundingBox const*>::iterator iter = std::find(mBoundingBoxes.begin(), mBoundingBoxes.end(), &pAABB);
    if (iter != mBoundingBoxes.end())
    {
        mBoundingBoxes.erase(iter);
        return true;
    }
    return false;
}

void CollisionLayer::drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const
{
    for (int i = 0, l = mBoundingBoxes.size() ; i < l ; ++i)
    {
        mBoundingBoxes[i]->drawDebug(pTarget, color);
    }
}