#include "..\..\include\engine\CollisionManager.h"


CollisionManager::CollisionManager(void) : mWasPressed(false)
{
    addLayerCollisions(GUI, MOUSE);
    mMouseBox.setBoxSize(1, 1);
    addBoundingBox(MOUSE, &mMouseBox);
}

CollisionManager::~CollisionManager(void)
{
}

void CollisionManager::ensureLayerAvailable(unsigned int pLayer)
{
    if (pLayer >= mLayers.size())
    {
        mLayers.resize(pLayer + 1);
    }
}

void CollisionManager::addLayerCollisions(unsigned int pFirstLayer, unsigned int pSecondLayer)
{
    ensureLayerAvailable(pFirstLayer);
    mLayers[pFirstLayer].addCollisionWithLayer(pSecondLayer);
}

void CollisionManager::removeLayerCollisions(unsigned int pFirstLayer, unsigned int pSecondLayer)
{
    ensureLayerAvailable(pFirstLayer);
    mLayers[pFirstLayer].removeCollisionWithLayer(pSecondLayer);
}

void CollisionManager::addBoundingBox(unsigned int pLayer, BoundingBox const* pBoundingBox)
{
    ensureLayerAvailable(pLayer);
    mLayers[pLayer].addBoundingBox(pBoundingBox);
}

void CollisionManager::checkCollisions(sf::Vector2i const& pMousePosition)
{
    mMouseBox.setBoxPosition(pMousePosition.x, pMousePosition.y);
    bool lIsPressed = sf::Mouse::isButtonPressed(sf::Mouse::Left);
    if (!lIsPressed && mWasPressed)
    {
        addLayerCollisions(GUI, MOUSE);
    }
    else
    {
        removeLayerCollisions(GUI, MOUSE);
    }
    mWasPressed = lIsPressed;
    for (int i = 0, l = mLayers.size() ; i < l ; i++)
    {
        mLayers[i].checkCollisions(mLayers);
    }
}

bool CollisionManager::checkCollisions(BoundingBox const& pAABB, int32_t pMask, BoundingBox const*& oCollider)
{
    for (int iLayerAct = 0, lLayerCount = mLayers.size() ; iLayerAct < lLayerCount && pMask ; ++iLayerAct, pMask >>= 1)
    {
        if ((pMask & 0x1) && mLayers[iLayerAct].checkCollisions(pAABB, oCollider))
        {
            return true;
        }
    }
    return false;
}

bool CollisionManager::checkCollisions(BoundingBox const& pAABB, BoundingBox const*& oCollider)
{
    return checkCollisions(pAABB, ~0, oCollider);
}

bool CollisionManager::checkCollisions(sf::Vector2f const& pPosition, int32_t pMask, BoundingBox const*& oCollider)
{
    for (int iLayerAct = 0, lLayerCount = mLayers.size() ; iLayerAct < lLayerCount && pMask ; ++iLayerAct, pMask >>= 1)
    {
        if ((pMask & 0x1) && mLayers[iLayerAct].checkCollisions(pPosition, oCollider))
        {
            return true;
        }
    }
    return false;
}

bool CollisionManager::checkCollisions(sf::Vector2f const& pPosition, BoundingBox const*& oCollider)
{
    return checkCollisions(pPosition, ~0, oCollider);
}

void CollisionManager::drawDebug(sf::RenderTarget& pTarget, sf::Color const& color) const
{
    for (int i = 0, l = mLayers.size() ; i < l ; ++i)
    {
        mLayers[i].drawDebug(pTarget, color);
    }
}

bool CollisionManager::removeBoudingBox(BoundingBox const& pAABB)
{
    for (int i = 0, l = mLayers.size() ; i < l ; ++i)
    {
        if (mLayers[i].removeBoundingBox(pAABB)) return true;
    }
    return false;
}

bool CollisionManager::removeBoudingBox(BoundingBox const& pAABB, unsigned short pLayer)
{
    if (mLayers.size() > pLayer)
    {
        return mLayers[pLayer].removeBoundingBox(pAABB);
    }
    return false;
}

unsigned int CollisionManager::removeAllInstancesBoudingBox(BoundingBox const& pAABB)
{
    unsigned int lCount = 0;
    for (int i = 0, l = mLayers.size() ; i < l ; ++i)
    {
        lCount += mLayers[i].removeBoundingBox(pAABB);
    }
    return lCount;
}
