#include "engine/Helpers.h"

#include <fstream>
#include <iostream>
#include <dirent.h>
#include <sstream>

sf::Vector2f screenToWorld(const sf::Vector2i& pScreen, const sf::RenderTarget* pTarget)
{
	sf::Vector2u target = pTarget->getSize();

	float purcentageX = 0.5f - ((float)target.x - (float)pScreen.x) / (float)target.x;
	float purcentageY = 0.5f - ((float)target.y - (float)pScreen.y) / (float)target.y;

	sf::View pView = pTarget->getView();

	return sf::Vector2f( pView.getCenter().x + purcentageX*pView.getSize().x, pView.getCenter().y + purcentageY*pView.getSize().y);
}

//--------------------------------------------------------------
// 
std::vector<std::string> &strSplit(const std::string &s, char delim, std::vector<std::string> &elems) 
{
    std::stringstream ss(s);
    std::string item;

    while(std::getline(ss, item, delim)) 
	{
        elems.push_back(item);
    }

    return elems;
}

//-----------------------------------------------------------------

std::vector<std::string> strSplit(const std::string &s, char delim) 
{
    std::vector<std::string> elems;
    return strSplit(s, delim, elems);
}

//------------------------------------------------------------------

float stringToFloat(const sf::String &pStr)
{
	return atof(pStr.toAnsiString().c_str());
}

//-------------------------------------------------------------------

std::string intToString(int pValue)
{
	std::stringstream StrStream;
	StrStream << pValue;
	return StrStream.str();
}