#include "engine/SFMLMath.h"

float sqrMagnitude(const sf::Vector2f& pVector)
{
	return pVector.x * pVector.x + pVector.y * pVector.y;
}

//----------------------------------------------------------------------------

float magnitude(const sf::Vector2f& pVector)
{
	return sqrt(sqrMagnitude(pVector));
}

sf::Vector2f normalize(const sf::Vector2f& pVector)
{
	float norme = magnitude(pVector);

	if(norme == 0)
		return sf::Vector2f(0,0);

	return sf::Vector2f(pVector.x/norme, pVector.y/norme);
}

//--------------------------------------------------------------------------

sf::Vector2f moveToward(const sf::Vector2f& pCurrent, const sf::Vector2f& pTarget, const float pMaxSpeed)
{
	sf::Vector2f toTarget = pTarget - pCurrent;

	if(sqrMagnitude(toTarget) == 0)
		return pCurrent;

	sf::Vector2f norm = normalize(toTarget);

	sf::Vector2f mov = norm * pMaxSpeed;

	if(magnitude(toTarget) < magnitude(mov))
	{
		return pTarget;
	}
	else
	{
		return pCurrent + mov;
	}
}