#include "engine/ScreenManager.h"
#include "engine/GameTime.h"

#include "engine/AScreen.h"

#include "engine/InputData.h"


using namespace std;

ScreenManager* ScreenManager::sInstance = NULL;

ScreenManager::ScreenManager(sf::RenderWindow* pWindow)
	:mWindow(pWindow)
{
	sInstance = this;

	sf::View lView(sf::Vector2f(0, 0), sf::Vector2f(800, 600));
	mWindow->setView(lView);
}


ScreenManager::~ScreenManager(void)
{
}

//--------------------------------------------------

void ScreenManager::loop()
{
	while (mWindow->isOpen())
    {
		InputData::getInstance()->reset();

		Time::tick();

		//*********Event Polling**********
		sf::Event event;
		while (mWindow->pollEvent(event))
		{
			// Request for closing the window
			if (event.type == sf::Event::Closed)
				mWindow->close();

			if(event.type == sf::Event::MouseWheelMoved)
			{
				InputData::getInstance()->mouseWheelDelta = event.mouseWheel.delta;
			}
		}
		//******************************

		mWindow->clear();

		update();
		draw();

		mWindow->display();
    }

	//std::cout<<"Exiting Loop"<<std::endl;

	list<AScreen*>::iterator lIt = mScreenList.begin();
	while(lIt != mScreenList.end())
	{
		delete (*lIt);
		lIt++;
	}
}

//--------------------------------------------------

void ScreenManager::update()
{

	list<AScreen*>::iterator lIt = mToPop.begin();
	while(lIt != mToPop.end())
	{
        AScreen* lToDel = *lIt;
		mScreenList.remove(*lIt);
        delete lToDel;
        ++lIt;
	}
    mToPop.clear();


	lIt = mScreenList.begin();

	if(lIt == mScreenList.end())
		return;

	//update le premier ecran 
	(*lIt)->update();
	lIt++;

	while(lIt != mScreenList.end())
	{
		if(!(*lIt)->isFrozen())
			(*lIt)->update();

		lIt++;
	}

}

//--------------------------------------------------

void ScreenManager::draw()
{
	list<AScreen*>::iterator lIt = mScreenList.end();

	while(lIt != mScreenList.begin())
	{
		lIt--;
		mWindow->setView((*lIt)->getView());
		(*lIt)->draw(mWindow);
	}
}

//--------------------------------------------------

void ScreenManager::pushScreen(AScreen* pScreen)
{
	if(!mScreenList.empty())
		mScreenList.front()->freeze(true);

	mWindow->setView(pScreen->getView());
	pScreen->setManager(this);

	mScreenList.push_front(pScreen);
	Time::tick();
}

//--------------------------------------------------

AScreen* ScreenManager::popScreen()
{
	if(mScreenList.empty())
		return NULL;

	mToPop.push_back(mScreenList.front());

	return mScreenList.front();
}

//--------------------------------------------------

AScreen* ScreenManager::peekScreen()
{
	if(mScreenList.empty())
		return NULL;

	return mScreenList.front();
}

//--------------------------------------------------
 
AScreen* ScreenManager::getScreen(unsigned int pIndex)
{
	if(pIndex < 0 || pIndex >= mScreenList.size())
		return NULL;

	int i = 0;
	list<AScreen*>::iterator lIt = mScreenList.begin();

	while(lIt != mScreenList.end())
	{
		if(i == pIndex)
			return (*lIt);

		i++;
		lIt++;
	}

	return NULL;
}

//--------------------------------------------

ScreenManager* ScreenManager::getInstance()
{
	 return sInstance;
}