#pragma once

#include "engine/Sprite.h"

#include "engine/GameTime.h"
#include "engine/TextureDatabase.h"

#include <iostream>


Sprite::Sprite(const std::string& pImagePath, const sf::Vector2f pPosition)
{
	mSprite = NULL;
	mTexture = NULL;

	loadFrom(pImagePath);

	mWasFliped = false;


	mSprite->setPosition(pPosition);
	mToDelete = false;

	mDeleteTexture = true;
}

Sprite::~Sprite()
{
	if(mDeleteTexture)
		TextureDatabase::unload(mTexture);

	//delete mSprite;
}

void Sprite::draw(sf::RenderTarget* pTarget) const
{
	sf::View view = pTarget->getView();
	sf::FloatRect rect(view.getCenter() - view.getSize()*0.5f, view.getSize());
	if(mSprite != NULL && !mSprite->getGlobalBounds().intersects(rect))
		return;

	pTarget->draw(*mSprite);
}

void Sprite::update()
{
}

void Sprite::flipX(bool pFlip)
{
	if(pFlip == mWasFliped)
		return;

	mSprite->setScale(pFlip ? -1.0f : 1.0f, 1.0f);
    
	if(pFlip)
	{
		mSprite->setOrigin((float)mSprite->getTextureRect().width, 0); 
		//setPosition(getPosition() + sf::Vector2f(mSprite->getGlobalBounds().width, 0.0f));
	}
	else
	{
		mSprite->setOrigin(0, 0); 
		//setPosition(getPosition() - sf::Vector2f(mSprite->getGlobalBounds().width, 0.0f));
	}
	mWasFliped = pFlip;
}

//-------------------------------------------------------------------------

void Sprite::loadFrom(const sf::String& pFile)
{
	if(mTexture != NULL)
	    TextureDatabase::unload(mTexture);

	if(mSprite != NULL)
		delete mSprite;

	mTexture = NULL;
	mSprite = new sf::Sprite();

	if(pFile != "")
	{
		mTexture = TextureDatabase::load(pFile);
		mSprite->setTexture(*mTexture);
	}
}