#include "engine/TextureDatabase.h"

TextureDatabase* TextureDatabase::sInstance = NULL;

sf::Texture* TextureDatabase::load(const sf::String& pPath)
{
	if(sInstance==NULL)
	{
		sInstance = new TextureDatabase();
	}

	if(sInstance->mAssets.count(pPath) > 0)
	{
		sf::Texture* tex = sInstance->mAssets[pPath]->texture;
		sInstance->mAssets[pPath]->counter += 1;

		return tex;
	}
	else
	{
		sf::Texture* tex = new sf::Texture();
		tex->loadFromFile(pPath);

		sInstance->mAssets[pPath] = new TextureAsset();
		sInstance->mAssets[pPath]->texture = tex;
		sInstance->mAssets[pPath]->counter = 1;
		sInstance->mLinked[tex] = sInstance->mAssets[pPath];

		return tex;
	}
}

//-----------------------------------------------------------------

void TextureDatabase::unload(sf::Texture* pTexture)
{
	if(sInstance==NULL)
	{
		sInstance = new TextureDatabase();
	}

	if(sInstance->mLinked.count(pTexture) > 0)
	{
		sInstance->mLinked[pTexture]->counter -= 1;

		if(sInstance->mLinked[pTexture]->counter < 0)
		{
			sInstance->mAssets.erase(sInstance->mLinked[pTexture]->path);
			sInstance->mLinked.erase(pTexture);
			delete pTexture;
		}
	}
}