#include "home/DisconnectedScreen.h"
#include "Config.h"
#include "home/HomeScreen.h"

DisconnectedScreen::DisconnectedScreen(void) : mBackground("data/home/home.png")
{
	mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
	mText = Button("Disconnected", mFont, false);
	mText.setPosition(sf::Vector2f(0, 350));
	mText.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mButton = Button("Back", mFont);
	mButton.setPosition(sf::Vector2f(0, 600));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mButton.setStyleHover(sf::Text::Bold);
	mButton.setCharacterSizeHover(36U);
}


DisconnectedScreen::~DisconnectedScreen(void)
{
}

void DisconnectedScreen::update()
{
	mText.update();
	mButton.update();
	if (mButton.isClicked())
	{
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(new HomeScreen());
	}
}

void DisconnectedScreen::draw(sf::RenderTarget* pTarget)
{
	pTarget->clear();
	mBackground.draw(pTarget);
	mText.draw(pTarget);
	mButton.draw(pTarget);
}
