#include "..\..\include\home\HomeScreen.h"
#include "str/STRScreen.h"
#include "platformer/PlatformerScreen.h"
#include "home/CreditsScreen.h"
#include "home/MatchmakingScreen.h"
#include "home/LanScreen.h"
#include "engine/Sprite.h"
#include "engine/Callback.h"
#include "Config.h"

#include <iostream>

HomeScreen::HomeScreen(float pScreenWidth, float pScreenHeight) : mBackground("data/home/home.png")
{
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
	mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);

	std::pair<Button, void (HomeScreen::*)(void)> lPair(Button("Matchmaking Worldwide", mFont), &HomeScreen::serv);
	lPair.first.setSize(sf::Vector2f(Config::Graphics::width, 80));
	lPair.first.setPosition(sf::Vector2f(0, 400));
	lPair.second = &HomeScreen::serv;
	mButtons.push_back(lPair);
	lPair.first.setString("LAN");
	lPair.first.setPosition(sf::Vector2f(0, 500));
	lPair.second = &HomeScreen::lan;
	mButtons.push_back(lPair);
	//lPair.first.setString("Host");
	//lPair.first.setPosition(sf::Vector2f(0, 490));
	//lPair.second = &HomeScreen::host;
	//mButtons.push_back(lPair);
	//lPair.first.setString("Join");
	//lPair.first.setPosition(sf::Vector2f(0, 570));
	//lPair.second = &HomeScreen::join;
	//mButtons.push_back(lPair);
	lPair.first.setString("Credits");
	lPair.first.setPosition(sf::Vector2f(0, 600));
	lPair.second = &HomeScreen::credits;
	mButtons.push_back(lPair);
	lPair.first.setString("No Friend Mode");
	lPair.first.setPosition(sf::Vector2f(0, 700));
	lPair.second = &HomeScreen::alone;
	mButtons.push_back(lPair);
}


HomeScreen::~HomeScreen(void)
{
}

void HomeScreen::update()
{
	for (unsigned int i = 0, l = mButtons.size() ; i < l ; ++i)
	{
		mButtons[i].first.update();
		if (mButtons[i].first.isClicked())
		{
			(this->*mButtons[i].second)();
		}
	}
}

void HomeScreen::draw(sf::RenderTarget* pTarget)
{
    pTarget->clear();
    mBackground.draw(pTarget);
    for (unsigned int i = 0, l = mButtons.size() ; i < l ; ++i)
    {
        mButtons[i].first.draw(pTarget);
    }
}

void HomeScreen::lan()
{
	ScreenManager::getInstance()->popScreen();
	ScreenManager::getInstance()->pushScreen(new LanScreen());
}

void HomeScreen::join()
{
}

void HomeScreen::host()
{
}

void HomeScreen::serv()
{
	ScreenManager::getInstance()->popScreen();
	ScreenManager::getInstance()->pushScreen(new MatchmakingScreen());
}

void HomeScreen::credits()
{
    ScreenManager::getInstance()->popScreen();
    ScreenManager::getInstance()->pushScreen(new CreditsScreen());
}

void HomeScreen::alone()
{
    AScreen* nextScreen;
  //  if (rand() % 2)
    {
      //  nextScreen = new STRScreen();
    }
    //else
    {
        nextScreen = new PlatformerScreen();
    }
    ScreenManager::getInstance()->popScreen();
    ScreenManager::getInstance()->pushScreen(nextScreen);
}
