#include "..\..\include\home\LanScreen.h"
#include "Config.h"
#include "home/DisconnectedScreen.h"
#include "home/StartScreen.h"
#include "home/HomeScreen.h"

LanScreen::LanScreen(void) : mTcpListener(), mTcpSocket(new sf::TcpSocket()), mUdpSocket(), mSprite("data/home/home.png")
{
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
	mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);
	mText = Button("Waiting for player to connect...", mFont, false);
	mText.setPosition(sf::Vector2f(0, 400));
	mText.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mText.update();
	mButton = Button("Back", mFont);
	mButton.setPosition(sf::Vector2f(0, 700));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mTcpListener.setBlocking(false);
	mTcpListener.listen(Config::Network::tcpPort);
	mUdpSocket.setBlocking(false);
	mUdpSocket.bind(Config::Network::udpReadPort);
}


LanScreen::~LanScreen(void)
{
}

void LanScreen::goToDisconnectedScreen()
{
	ScreenManager::getInstance()->popScreen();
	ScreenManager::getInstance()->pushScreen(new DisconnectedScreen());
}

void LanScreen::update()
{
	mButton.update();
	switch (mTcpListener.accept(*mTcpSocket))
	{
	case sf::Socket::Done:
		{
			ScreenManager::getInstance()->popScreen();
			ScreenManager::getInstance()->pushScreen(new StartScreen(std::unique_ptr<Network>(new Network(std::move(mTcpSocket), true))));
			return;
		}
		break;
	case sf::Socket::NotReady:
		break;
	default:
		goToDisconnectedScreen();
		return;
	}
	sf::Packet lPacket;
	sf::IpAddress lAddress;
	unsigned short lPort;
	switch (mUdpSocket.receive(lPacket, lAddress, lPort))
	{
	case sf::Socket::Done:
		{
			std::string lString;
			lPacket >> lString;
			if (lString == Config::Network::logMessage && sf::IpAddress::getLocalAddress().toInteger() <= lAddress.toInteger())
			{
				mTcpSocket->setBlocking(true);
				switch (mTcpSocket->connect(lAddress, Config::Network::tcpPort, sf::seconds(Config::Network::lookupLiveTime)))
				{
				case sf::Socket::Done:
					ScreenManager::getInstance()->popScreen();
					ScreenManager::getInstance()->pushScreen(new StartScreen(std::unique_ptr<Network>(new Network(std::move(mTcpSocket)))));
					break;
				case sf::Socket::NotReady:
					break;
				default:
					goToDisconnectedScreen();
					break;
				}
				mTcpSocket->setBlocking(false);
			}
		}
		break;
	case sf::Socket::NotReady:
		break;
	default:
		goToDisconnectedScreen();
		return;
	}
	if (mButton.isClicked())
	{
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(new HomeScreen());
	}
}

void LanScreen::draw(sf::RenderTarget* pTarget)
{
	mSprite.draw(pTarget);
	mText.draw(pTarget);
	mButton.draw(pTarget);
}
