#include "home/MatchmakingScreen.h"
#include "home/HomeScreen.h"
#include "home/DisconnectedScreen.h"
#include "str/STRScreen.h"
#include "platformer/PlatformerScreen.h"
#include "home/StartScreen.h"
#include "Config.h"

MatchmakingScreen::MatchmakingScreen(void) : mTcpSocket(new sf::TcpSocket()), mConnected(false), mFound(false), mSprite("data/home/home.png"), mChange(false)
{
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
	mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);

	mText = Button("Connecting to server...", mFont, false);
	mText.setPosition(sf::Vector2f(0, 400));
	mText.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mButton = Button("Back", mFont);
	mButton.setPosition(sf::Vector2f(0, 700));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mTcpSocket->setBlocking(false);
}


MatchmakingScreen::~MatchmakingScreen(void)
{
}

void MatchmakingScreen::update()
{
	mButton.update();
	if (mButton.isClicked())
	{
		mTcpSocket->disconnect();
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(new HomeScreen());
	}
	else if (!mChange)
	{
		mChange = true;
	}
	else if (!mConnected)
	{
		mTcpSocket->setBlocking(true);
		switch (mTcpSocket->connect(Config::Network::serverAddress, Config::Network::tcpPort))
		{
		case sf::Socket::Done:
			mText.setString("Waiting for player...");
			mConnected = true;
			break;
		case sf::Socket::NotReady:
			break;
		default:
			goToDisconnectedScreen();
			break;
		}
		mTcpSocket->setBlocking(false);
	}
	else
	{
		sf::Packet lPacket;
		switch (mTcpSocket->receive(lPacket))
		{
		case sf::Socket::Done:
			ScreenManager::getInstance()->popScreen();
			ScreenManager::getInstance()->pushScreen(new StartScreen(std::unique_ptr<Network>(new Network(std::move(mTcpSocket), lPacket))));
			break;
		case sf::Socket::NotReady:
			break;
		default:
			goToDisconnectedScreen();
			break;
		}
	}
}

void MatchmakingScreen::goToDisconnectedScreen()
{
	mTcpSocket->disconnect();
	ScreenManager::getInstance()->popScreen();
	ScreenManager::getInstance()->pushScreen(new DisconnectedScreen());
}

void MatchmakingScreen::draw(sf::RenderTarget* pTarget)
{
	mSprite.draw(pTarget);
	mButton.draw(pTarget);
	mText.draw(pTarget);
}
