#include "home/StartScreen.h"
#include "str/STRScreen.h"
#include "platformer/PlatformerScreen.h"
#include "Config.h"

StartScreen::StartScreen(std::unique_ptr<Network> pNetwork) : mNetwork(std::move(pNetwork)), mReady(false), mChange(false), mSprite("data/home/home.png")
{
    mFont.loadFromFile("data/home/JandaManateeSolid.ttf");
	mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);
	mButton = Button("Starting game...", mFont, false);
	mButton.setPosition(sf::Vector2f(0, 400));
	mButton.setSize(sf::Vector2f(Config::Graphics::width, 100));
	mButton.update();
}


StartScreen::~StartScreen(void)
{
}

void StartScreen::update()
{
	if (mChange)
	{
		AScreen* lScreen;
		bool lNextGameKind;
		if (mNetwork.get())
		{
			lNextGameKind = mNetwork->nextGameKind();
		}
		else
		{
			lNextGameKind = rand() % 2;
		}
		if (lNextGameKind)
		{
			lScreen = new STRScreen(std::move(mNetwork));
		}
		else
		{
			lScreen = new PlatformerScreen(std::move(mNetwork));
		}
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(lScreen);
	}
	mChange = true;
}

void StartScreen::draw(sf::RenderTarget* pTarget)
{
	mSprite.draw(pTarget);
	mButton.draw(pTarget);
}
