#include "home/WinScreen.h"
#include "home/StartScreen.h"
#include "engine/GameTime.h"
#include "Config.h"


WinScreen::WinScreen(std::unique_ptr<Network> pNetwork, bool pWin) : AScreen(), mNetwork(std::move(pNetwork)), mChange(false), mSprite(pWin ? "data/home/win.png" : "data/home/lose.png"), mWait(5)
{
    mView.setCenter(0.5f * Config::Graphics::width, 0.5f * Config::Graphics::height);
}


WinScreen::~WinScreen(void)
{
}

void WinScreen::update()
{
	if (mWait <= 0)
	{
		ScreenManager::getInstance()->popScreen();
		ScreenManager::getInstance()->pushScreen(new StartScreen(std::move(mNetwork)));
	}
	else
	{
		mWait -= Time::deltaTime();
	}
}

void WinScreen::draw(sf::RenderTarget* pTarget)
{
    mSprite.draw(pTarget);
}