#include <SFML/Audio.hpp>
#include <SFML/Graphics.hpp>

#include <cstdlib>
#include <ctime>

#include "engine/ScreenManager.h"
#include "Config.h"
#include "CoreScreen.h"

#include "platformer/PlatformerScreen.h"
#include "str/STRScreen.h"
#include "home/HomeScreen.h"
#include "home/DisconnectedScreen.h"
 
 int main()
 {
     srand((unsigned int) time(NULL) ^ 18);
	 Config::LoadFromFile("data/config.ini");

     // Create the main window
	 sf::RenderWindow window(sf::VideoMode(Config::Graphics::width, Config::Graphics::height), "Meat VS Beat");

	 ScreenManager lManager(&window);

     //lManager.pushScreen(new PlatformerScreen((float)Config::Graphics::width, (float)Config::Graphics::height));
     lManager.pushScreen(new HomeScreen());
	 //lManager.pushScreen(new DisconnectedScreen());

	 //lManager.pushScreen(new STRScreen());

	 lManager.loop();
 
     // Start the game loop
     /*while (window.isOpen())
     {
         // Process events
         sf::Event event;
         while (window.pollEvent(event))
         {
             // Close window : exit
             if (event.type == sf::Event::Closed)
                 window.close();
         }
 
         // Clear screen
         window.clear();
 
         // Update the window
         window.display();
     }*/
 
     return EXIT_SUCCESS;
 }