#include "..\..\include\network\Network.h"
#include "engine/GameTime.h"
#include <cstdint>

Network::Network(std::unique_ptr<sf::TcpSocket> pSocket, bool pHasOwnership) : mSocket(std::move(pSocket)), mIsDisconnected(false), mIsOtherReady(false)
{
    if (pHasOwnership)
    {
        mGameToPlay = (std::rand() % 2);
        sf::Packet lPacket;
        lPacket << !mGameToPlay;
        (*mSocket).send(lPacket);
        (*mSocket).setBlocking(false);
    }
    else
    {
        sf::Packet lPacket;
        sf::TcpSocket& lSocket = *mSocket.get();
        lSocket.setBlocking(true);
        lSocket.receive(lPacket);
        lSocket.setBlocking(false);
        lPacket >> mGameToPlay;
    }
}
#include <iostream>

Network::Network(std::unique_ptr<sf::TcpSocket> pSocket, sf::Packet& pPacket) : mSocket(std::move(pSocket)), mIsDisconnected(false), mIsOtherReady(false)
{
    pPacket >> mGameToPlay;
}

Network::~Network(void)
{
}

void Network::checkConnection(sf::Socket::Status pStatus)
{
    if (pStatus == sf::Socket::Disconnected || pStatus == sf::Socket::Error)
    {
        mIsDisconnected = true;
    }
}

void Network::platformerSendHeight(float pHeight)
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::PLATFORMER_HEIGHT << pHeight));
}

void Network::platformerEaten(float pCholesterol)
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::PLATFORMER_EAT << pCholesterol));
}

void Network::platformerVictory()
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::WIN));
}

void Network::strKillMember(Network::Member pMember)
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::STR_KILL_MEMBER << (uint8_t)pMember));
}

void Network::strSendMemberLife(Member pMember, float pState)
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::STR_MEMBER_LIFE << (uint8_t)pMember << pState));
}

void Network::strVictory()
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::WIN));
}

bool Network::replay()
{
    mIsOtherReady = false;
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::REPLAY));
    if (mIsDisconnected) return false;
    if (mIsOtherReplaying) return true;
    sf::Packet lPacket;
    if (!waitMessage(lPacket)) return false;
    uint8_t lType;
    lPacket >> lType;
    if (lType != Network::REPLAY)
    {
        mIsDisconnected = true;
    }
    return !mIsDisconnected;
}

void Network::quit()
{
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::QUIT));
}

void Network::ready()
{
    mIsOtherReplaying = false;
    checkConnection(mSocket->send(sf::Packet() << (uint8_t)Network::READY));
}

bool Network::isOtherReady()
{
    if (mIsOtherReady)
	{
		mIsOtherReady = false;
		return true;
	}
	Network::Message lMessage;
	while (!mIsOtherReady && !mIsDisconnected && getOneMessage(lMessage) != 0) { }
	if (mIsOtherReady)
	{
		mIsOtherReady = false;
		return true;
	}
	return false;
}

bool Network::isDisconnected()
{
    return mIsDisconnected;
}

bool Network::receiveMessage(sf::Packet& oPacket)
{
    sf::Socket::Status lStatus = mSocket->receive(oPacket);
    checkConnection(lStatus);
    return lStatus == sf::Socket::Done;
}

bool Network::waitMessage(sf::Packet& oPacket)
{
    mSocket->setBlocking(true);
    checkConnection(mSocket->receive(oPacket));
    mSocket->setBlocking(false);
    return !mIsDisconnected;
}

Network::Message::Message()
{
}

Network::Message::~Message()
{
}

Network::Message::Message(sf::Packet& pPacket)
{
    uint8_t lUint8;
    float lFloat;
    bool lBool;
    pPacket >> lUint8;
    mType = (MessageType)lUint8;
    switch (mType)
    {
    case GAME_TYPE:
        pPacket >> lBool;
        mFirst.mBool = lBool;
        break;
    case READY:
    case REPLAY:
    case QUIT:
    case WIN:
        break;
    case PLATFORMER_HEIGHT:
    case PLATFORMER_EAT:
        pPacket >> lFloat;
        mFirst.mFloat = lFloat;
        break;
    case STR_KILL_MEMBER:
        pPacket >> lUint8;
        mFirst.mUint8 = lUint8;
        break;
    case STR_MEMBER_LIFE:
        pPacket >> lUint8;
        mFirst.mUint8 = lUint8;
        pPacket >> lFloat;
        mSecond.mFloat = lFloat;
        break;
    }
}

bool Network::Message::isForPlateformerPlayer()
{
    switch (mType)
    {
    case WIN:
    case STR_KILL_MEMBER:
    case STR_MEMBER_LIFE:
        return true;
    default:
        return false;
    }
}

bool Network::Message::isForRtsPlayer()
{
    switch (mType)
    {
    case WIN:
    case PLATFORMER_EAT:
    case PLATFORMER_HEIGHT:
        return true;
    default:
        return false;
    }
}

bool Network::Message::isSystem()
{
    switch (mType)
    {
    case GAME_TYPE:
    case QUIT:
    case READY:
    case REPLAY:
        return true;
    default:
        return false;
    }
}

bool Network::Message::isGameType()
{
    return mType == GAME_TYPE;
}

bool Network::Message::getGameType()
{
    return mFirst.mBool;
}

bool Network::Message::isEat()
{
    return mType == PLATFORMER_EAT;
}

bool Network::Message::isHeight()
{
    return mType == PLATFORMER_HEIGHT;
}

bool Network::Message::isMemberKill()
{
    return mType == STR_KILL_MEMBER;
}

bool Network::Message::isMemberLife()
{
    return mType == STR_MEMBER_LIFE;
}

bool Network::Message::isWin()
{
    return mType == WIN;
}

Network::Member Network::Message::getMember()
{
    return (Member)mFirst.mUint8;
}

float Network::Message::getCholesterol()
{
    return mFirst.mFloat;
}

float Network::Message::getLife()
{
    return mSecond.mFloat;
}

float Network::Message::getHeight()
{
    return mFirst.mFloat;
}

int Network::getOneMessage(Network::Message& oMessage)
{
    sf::Packet lPacket;
    if (!receiveMessage(lPacket)) return 0;
    oMessage = Message(lPacket);
    if (oMessage.isSystem())
    {
        switch (oMessage.mType)
        {
        case QUIT:
            mIsDisconnected = true;
            return -1;
        case READY:
            mIsOtherReady = true;
            return -1;
        case REPLAY:
            mIsOtherReplaying = true;
            return -1;
        }
    }
    return 1;
}

bool Network::getMessage(Network::Message& oMessage)
{
	for (;;)
	{
		switch (getOneMessage(oMessage))
		{
		case -1:
			continue;
		case 1:
			return true;
		case 0:
		default:
			return false;
		}
	}
}

bool Network::nextGameKind()
{
    return (mGameToPlay = !mGameToPlay);
}
