#include "platformer/Collectible.h"

#define PI 3.1415926535f
#include <cmath>

#include "engine/GameTime.h"
#include "platformer/PlatformerScreen.h"

Collectible::Collectible(const std::string& pSpriteName, int pEnergyValue, int pCholesterolValue, PlatformerScreen* pPlatformerScreen, int pSpriteIndex):
    Sprite(pSpriteName, sf::Vector2f()),
    BoundingBox(Sprite::getSFSprite().getLocalBounds().width, Sprite::getSFSprite().getLocalBounds().width),
    mEnergyValue(pEnergyValue),
    mCholesterolValue(pCholesterolValue),
    mPlatformerScreen(pPlatformerScreen),
    mSpriteIndex(pSpriteIndex),
    mInstantiationStartTime(((float)rand() / (float)RAND_MAX) * PI)
{
}

Collectible::~Collectible()
{
}

void Collectible::setPosition(sf::Vector2f pPos)
{
    Sprite::setPosition(pPos);
    BoundingBox::setBoxPosition(pPos);
}

void Collectible::update()
{
    setPosition(getPosition() + std::sinf(5.0f *(mInstantiationStartTime += Time::deltaTime())) * sf::Vector2f(0.0f, 0.03125f));
}

void Collectible::draw(sf::RenderTarget* pTarget) const
{
    Sprite::draw(pTarget);
}

void Collectible::removeFromList() const
{
    mPlatformerScreen->removeSprite(mSpriteIndex);
}
