#include "platformer/Enemy.h"

#include <cstdlib>

#include "Config.h"
#include "engine/GameTime.h"

#include "platformer/PlatformerScreen.h"
#include "platformer/Platform.h"

Enemy::Enemy(Platform* pSupportingPlatform, PlatformerScreen* pPlatformerScreen, int pSpriteIndex):
    AnimatedSprite(sf::Vector2f()),
    mSupportingPlatform(pSupportingPlatform),
    mPlatformerScreen(pPlatformerScreen),
    mSpriteIndex(pSpriteIndex),
    BoundingBox(),
    mLife(Config::PlatformerEnemy::life)
{
    addAnimation("idle", "data/platformer/Enemy/idle", 1.0f);
    addAnimation("idle", "data/platformer/Enemy/jump", 1.0f);
    play("idle");
    mDeltaMove = (((rand() & 1) != 0) ? -1.0f : 1.0f) * Config::PlatformerEnemy::speed;
    AnimatedSprite::flipX(mDeltaMove > 0.0f);
    sf::Rect<float> lBounds = Sprite::getSFSprite().getLocalBounds();
    sf::Vector2f lNewPosition = pSupportingPlatform->getSFSprite().getPosition() - sf::Vector2f(0.0f, mSprite->getLocalBounds().height);
    setBoxSize(lBounds.width, lBounds.height);
    float lProb = (float)rand() / (float)RAND_MAX;
    lNewPosition.x += lProb * (mSupportingPlatform->getSFSprite().getLocalBounds().width - mSprite->getLocalBounds().width);
    Enemy::setPosition(lNewPosition);
}

Enemy::~Enemy()
{
}

bool Enemy::tryKill(float damage)
{
    mLife -= damage;
    return (mLife <= 0);
}

void Enemy::setPosition(sf::Vector2f pPos)
{
    Sprite::setPosition(pPos);
    setBoxPosition(pPos);
}

void Enemy::update()
{
	AnimatedSprite::update();
    sf::Vector2f lNewPosition = Sprite::getPosition();
    lNewPosition.x += mDeltaMove * Time::deltaTime();
    if (lNewPosition.x <= mSupportingPlatform->getPosition().x)
    {
        lNewPosition.x = mSupportingPlatform->getPosition().x;
        mDeltaMove *= -1.0f;
        AnimatedSprite::flipX(true);
    }
    else if (lNewPosition.x >= (mSupportingPlatform->getPosition().x + mSupportingPlatform->getSFSprite().getLocalBounds().width - mSprite->getLocalBounds().width))
    {
        lNewPosition.x = mSupportingPlatform->getPosition().x + mSupportingPlatform->getSFSprite().getLocalBounds().width - mSprite->getLocalBounds().width;
        mDeltaMove *= -1.0f;
        AnimatedSprite::flipX(false);
    }
    Enemy::setPosition(lNewPosition);
}

void Enemy::draw(sf::RenderTarget* pTarget) const
{
    AnimatedSprite::draw(pTarget);
}

void Enemy::removeFromList() const
{
    mPlatformerScreen->removeSprite(mSpriteIndex);
}
