#include "platformer/Platform.h"

#include <dirent.h>

Platform::Platform(sf::Vector2f const& pPosition) :
    Sprite("data/platformer/Platform/plateforme01.png", pPosition),
    BoundingBox(sf::Vector2f(Sprite::getSFSprite().getLocalBounds().width, Sprite::getSFSprite().getLocalBounds().height), pPosition)
{
}

Platform::Platform(float pPositionY, float pScreenWidth) :
    Sprite("", sf::Vector2f()),
    BoundingBox()
{
    std::vector<sf::String> lImageFilenames;
	struct dirent *ent;
	DIR *lDir = opendir ("data/platformer/Platform/");

    if (lDir != NULL) 
    {
        while ((ent = readdir (lDir)) != NULL) 
        {
            if(ent->d_type == DT_REG)
            {
                sf::String lStr(ent->d_name);
                if(lStr.find(".png") != sf::String::InvalidPos || lStr.find(".jpg") != sf::String::InvalidPos)
                    lImageFilenames.push_back(lStr);
            }
        }
        closedir (lDir);
    }

    Sprite::loadFrom(sf::String("data/platformer/Platform/") + lImageFilenames[rand() % lImageFilenames.size()]);
    float lProb = (float)rand() / (float)RAND_MAX;
    Sprite::mSprite->setPosition(lProb * (pScreenWidth - mSprite->getLocalBounds().width), pPositionY);
    setBoxSize(sf::Vector2f(Sprite::getSFSprite().getLocalBounds().width, Sprite::getSFSprite().getLocalBounds().height));
    setBoxPosition(mSprite->getPosition());
}

Platform::~Platform()
{
}

void Platform::update()
{
    Sprite::update();
}

void Platform::draw(sf::RenderTarget* pTarget) const
{
    Sprite::draw(pTarget);
}