#include "str/BodyGridCell.h"
#include "str/Unit.h"

BodyGridCell::BodyGridCell()
{
	mFat = 0;

	mVisited = false;
}

//------------------------------------------

void BodyGridCell::setType(Type pType)
{
	mType = pType;

	char* temp[] = {"data/STR/Body/ground1",
					"data/STR/Body/ground2",
					"data/STR/Body/ground4",
					"data/STR/Body/ground4.png",
					"data/STR/Body/ground5.png"};

	char* tempWall[] = {"data/STR/Body/wall1.png",
						"data/STR/Body/wall2.png",
						"data/STR/Body/wall3.png",
						"data/STR/Body/wall4.png",
						"data/STR/Body/wall5.png"};

	if(pType == Type::GROUND)
	{
		addAnimation("idle", temp[rand()%3], 1.0f);
		mAnimations["idle"]->play();
		mAnimations["idle"]->stop();

		mAnimations["idle"]->setFrame(0);

		mPassable = true;
	}
	else
	{
		loadFrom(tempWall[rand()%5]);
		mPassable = false;
	}
}

//-------------------------------------------

void BodyGridCell::registerUnit(Unit* pUnit)
{
	mUnits.push_back(pUnit);
}

//-------------------------------------------

void BodyGridCell::unregisterUnit(Unit* pUnit)
{
	mUnits.remove(pUnit);
}

//-------------------------------------------

bool BodyGridCell::isPassable() const
{
	return mPassable;
}

//-------------------------------------------

void BodyGridCell::setPassable(bool pPassable)
{
	mPassable = pPassable;
}

//-------------------------------------------

void BodyGridCell::setId(int pId)
{
	mId = pId;
}

//-------------------------------------------

void BodyGridCell::increaseFatification(float pAmount)
{
	mFat += pAmount;
	mFat = std::min(mFat, 1.0f);
}

float BodyGridCell::getFat()
{
	return mFat;
}

//-------------------------------------------

int BodyGridCell::getId() const
{
	return mId;
}

//-------------------------------------------

void BodyGridCell::draw(sf::RenderTarget* pTarget) const
{
	Sprite::draw(pTarget);

	/*if(mFat > 0.1f)
		pTarget->draw(mRect);*/
}

//-------------------------------------------

void BodyGridCell::update()
{
	/*mRect.setPosition(getPosition());
	mRect.setFillColor(sf::Color(255,255, 255, 255*mFat));*/

	AnimatedSprite::update();

	if(mFat > 0.01f)
	{
		if(mFat < 0.20f)
			mAnimations["idle"]->setFrame(0);
		else if(mFat < 0.40f)
			mAnimations["idle"]->setFrame(1);
		else if(mFat < 0.60f)
			mAnimations["idle"]->setFrame(2);
		else if(mFat < 0.80f)
			mAnimations["idle"]->setFrame(3);
		else
			mAnimations["idle"]->setFrame(4);
	}
}

//---------------------------------------------

void BodyGridCell::setGrid(int i, int j, BodyGrid* pGrid)
{
	mGrid = pGrid;

	mIdx = sf::Vector2i(i,j);
}

//---------------------------------------------

bool BodyGridCell::isVisited() const
{
	return mVisited;
}

void BodyGridCell::setVisited(bool pVisited)
{
	mVisited = pVisited;
}

//---------------------------------------------

sf::Vector2i BodyGridCell::getIndex()
{
	return mIdx;
}