#include "str/objects/FatPile.h"
#include "str/units/Gatherer.h"

#include "engine/GameTime.h"

FatPile::FatPile()
	: STRObject()
{
	mMaxAmount = 40;
	mFatAmount = mMaxAmount;

	mCenter = sf::Vector2f(0,0);

	mRange = 40;

	addAnimation("idle", "data/STR/Body/fat", 1.0f);
	play("idle");
}

//----------------------------------

void FatPile::draw(sf::RenderTarget* pTarget) const
{
	mSprite->setScale(mFatAmount/mMaxAmount, mFatAmount/mMaxAmount);

	//mSprite->setColor(sf::Color(255,255,255, 255 * mFatAmount/mMaxAmount));

	STRObject::draw(pTarget);
}

//---------------------------------

void FatPile::use(Unit* pUnit)
{
	if(mFatAmount <= 0)
		return;

	Gatherer* ga = dynamic_cast<Gatherer*>(pUnit);

	if(ga != NULL)
	{
		if(ga->isFull())
			return;

		float amount = Time::deltaTime();
		amount = std::min(amount, mFatAmount);

		mFatAmount -= amount;
		ga->addFat(amount);

		if(mFatAmount <= 0)
			mGrid->unregisterObject(this);
	}
}

//---------------------------------------------

void FatPile::onPlaced(BodyGrid* pGrid, int i, int j)
{
	setGrid(pGrid);

	mGrid->getAt(i,j)->setPassable(false);
}