#include "engine/SFMLMath.h"
#include "engine/GameTime.h"

#include "str/units/Leucocyte.h"
#include "str/units/Fighter.h"

Fighter::Fighter()
{
	addAnimation("idle", "data/STR/Units/soldat", 1.2f);
	play("idle");

	mSpeed = 150.0f;

	mMaxHealth = 10.0f;
	mHealth = mMaxHealth;

	mLeucocyteTarget = NULL;
}

//------------------------------

void Fighter::update()
{
	Unit::update();

	if(mLeucocyteTarget != NULL)
	{
		if(mLeucocyteTarget->isDead())
		{
			mLeucocyteTarget = NULL;
			block(false);
			return;
		}

		float dist = sqrMagnitude(mLeucocyteTarget->getPosition() - getPosition());

		if(dist < 32.0f*32.0f)
		{
			mLeucocyteTarget->block(true);

			mLeucocyteTarget->forceTarget(this);

			block(true);

			mLeucocyteTarget->hurt(Time::deltaTime());

			if(mLeucocyteTarget->isDead())
			{
				mLeucocyteTarget = NULL;
				block(false);
			}
		}
	}
}

//-----------------------------------------------------------------------

void Fighter::checkLeucocyte(std::list<Leucocyte*>& pList)
{
	if(mLeucocyteTarget != NULL)
		return;

	std::list<Leucocyte*>::iterator it = pList.begin();

	float closest = 10000000.0f;
	while(it != pList.end())
	{
		float dist = sqrMagnitude((*it)->getPosition() - getPosition());

		if( dist <= 32.0f*32.0f && dist < closest)
		{
			closest = dist;
			mLeucocyteTarget = (*it);
		}

		++it;
	}
}