#include "str/units/Gatherer.h"

Gatherer::Gatherer()
	: Unit()
{
	addAnimation("idle", "data/STR/Units/recolteur", 1.0f);
	play("idle");

	mMaxFat = 10;
	mFat = 0;

	mFatBar.setSize(sf::Vector2f(10, 0));
	mFatBar.setFillColor(sf::Color(0,255,0));

	mSpeed = 128.0f;

	mMaxHealth = 10.0f;
	mHealth = mMaxHealth;
}

//--------------------------------------------------------------------------

float Gatherer::getFat()
{
	return mFat;
}

//--------------------------------------------------------------------------

void Gatherer::addFat(float pFat)
{
	mFat = std::max(0.0f, std::min(mMaxFat, mFat + pFat));
}

//--------------------------------------------------------------------------

bool Gatherer::isFull()
{
	if(mFat >= mMaxFat)
		return true;

	return false;
}

//--------------------------------------------------------------------------

void Gatherer::update()
{
	Unit::update();

	computeFatBar();
}

//--------------------------------------------------------------------------

void Gatherer::draw(sf::RenderTarget* pTarget) const
{
	Unit::draw(pTarget);

	pTarget->draw(mFatBar);
}

//--------------------------------------------------------------------------

void Gatherer::computeFatBar()
{
	float size = mFat/mMaxFat * 32;

	mFatBar.setSize(sf::Vector2f(10, size));
	mFatBar.setPosition(getPosition().x, getPosition().y + (32 - size));
}