
#include "engine/SFMLMath.h"
#include "engine/GameTime.h"

#include "str/units/Leucocyte.h"


Leucocyte::Leucocyte()
{
	addAnimation("idle", "data/STR/Units/Leucocyte", 0.6f);
	play("idle");

	mUnitTarget = NULL;

	mSeeRange = 256.0f;
	mSpeed = 150.0f;

	mMaxHealth = 10.0f;
	mHealth = mMaxHealth;
}

//-----------------------------------------

void Leucocyte::update()
{
	Unit::update();

	if(mUnitTarget != NULL)
	{
		if(mUnitTarget->isDead())
		{
			mUnitTarget = NULL;
			block(false);
			return;
		}

		float dist = sqrMagnitude(mUnitTarget->getPosition() - getPosition());

		if(dist < 32.0f*32.0f)
		{
			mUnitTarget->block(true);
			block(true);

			mUnitTarget->hurt(Time::deltaTime());

			if(mUnitTarget->isDead())
			{
				mUnitTarget = NULL;
				block(false);
			}
		}
	}
}

//-----------------------------------------

void Leucocyte::forceTarget(Unit* pTarget)
{
	if(mUnitTarget != NULL)
	{
		mUnitTarget->block(false);
	}

	mUnitTarget = pTarget;
}

//-----------------------------------------

void Leucocyte::lookForTarget(std::list<Unit*>& pUnits)
{
	if(mUnitTarget != NULL)
	{
		if(mUnitTarget->caseChanged())
		{
			sf::Vector2i idx = mGrid->getCellIdxFromWorld(mUnitTarget->getPosition());
			gotoCase(idx.x, idx.y);
		}
	}
	else
	{
		std::list<Unit*>::iterator it = pUnits.begin();

		float closest = 10000000.0f;
		while(it != pUnits.end())
		{
			float dist = sqrMagnitude((*it)->getPosition() - getPosition());

			if( dist <= mSeeRange*mSeeRange && dist < closest)
			{
				closest = dist;
				mUnitTarget = (*it);
			}

			++it;
		}

		if(mUnitTarget != NULL)
		{
			sf::Vector2i idx = mGrid->getCellIdxFromWorld(mUnitTarget->getPosition());
			gotoCase(idx.x, idx.y);
		}
	}
}